/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.util.function.Supplier;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;

public final class ProfilingLicenseChecker {
    private static final LicensedFeature.Momentary UNIVERSAL_PROFILING_FEATURE = LicensedFeature.momentary(null, (String)"universal_profiling", (License.OperationMode)License.OperationMode.ENTERPRISE);
    private final Supplier<XPackLicenseState> licenseStateResolver;

    public ProfilingLicenseChecker(Supplier<XPackLicenseState> licenseStateResolver) {
        this.licenseStateResolver = licenseStateResolver;
    }

    public boolean isSupportedLicense() {
        return UNIVERSAL_PROFILING_FEATURE.checkWithoutTracking(this.licenseStateResolver.get());
    }

    public void requireSupportedLicense() {
        if (!UNIVERSAL_PROFILING_FEATURE.check(this.licenseStateResolver.get())) {
            throw LicenseUtils.newComplianceException((String)UNIVERSAL_PROFILING_FEATURE.getName());
        }
    }
}

