/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.template;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.ilm.DeleteAction;
import org.elasticsearch.xpack.core.ilm.ForceMergeAction;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyUtils;
import org.elasticsearch.xpack.core.ilm.LifecycleType;
import org.elasticsearch.xpack.core.ilm.ReadOnlyAction;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.SetPriorityAction;
import org.elasticsearch.xpack.core.ilm.ShrinkAction;
import org.elasticsearch.xpack.core.ilm.TimeseriesLifecycleType;

public class LifecyclePolicyConfig {
    public static final NamedXContentRegistry DEFAULT_X_CONTENT_REGISTRY = new NamedXContentRegistry(List.of(new NamedXContentRegistry.Entry(LifecycleType.class, new ParseField("timeseries", new String[0]), p -> TimeseriesLifecycleType.INSTANCE), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("rollover", new String[0]), RolloverAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("set_priority", new String[0]), SetPriorityAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("forcemerge", new String[0]), ForceMergeAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("shrink", new String[0]), ShrinkAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("readonly", new String[0]), ReadOnlyAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("delete", new String[0]), DeleteAction::parse)));
    private final String policyName;
    private final String fileName;
    private final Map<String, String> templateVariables;

    public LifecyclePolicyConfig(String policyName, String fileName) {
        this(policyName, fileName, Collections.emptyMap());
    }

    public LifecyclePolicyConfig(String policyName, String fileName, Map<String, String> templateVariables) {
        this.policyName = policyName;
        this.fileName = fileName;
        this.templateVariables = templateVariables;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public LifecyclePolicy load(NamedXContentRegistry xContentRegistry) {
        return LifecyclePolicyUtils.loadPolicy(this.policyName, this.fileName, this.templateVariables, xContentRegistry);
    }
}

