/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import org.apache.http.HttpHost;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.IOSession;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.ssl.SslDiagnostics;
import org.elasticsearch.xpack.core.ssl.AbstractSslBuilder;

class SSLIOSessionStrategyBuilder
extends AbstractSslBuilder<SSLIOSessionStrategy> {
    public static final SSLIOSessionStrategyBuilder INSTANCE = new SSLIOSessionStrategyBuilder();

    SSLIOSessionStrategyBuilder() {
    }

    @Override
    SSLIOSessionStrategy build(SSLContext sslContext, String[] protocols, String[] ciphers, final HostnameVerifier verifier) {
        return new SSLIOSessionStrategy(this, sslContext, protocols, ciphers, verifier){

            protected void verifySession(HttpHost host, IOSession iosession, SSLSession session) throws SSLException {
                if (!verifier.verify(host.getHostName(), session)) {
                    Certificate[] certs = session.getPeerCertificates();
                    X509Certificate x509 = (X509Certificate)certs[0];
                    X500Principal x500Principal = x509.getSubjectX500Principal();
                    String altNames = Strings.collectionToCommaDelimitedString((Iterable)SslDiagnostics.describeValidHostnames((X509Certificate)x509));
                    throw new SSLPeerUnverifiedException(LoggerMessageFormat.format((String)"Expected SSL certificate to be valid for host [{}], but it is only valid for subject alternative names [{}] and subject [{}]", (Object[])new Object[]{host.getHostName(), altNames, x500Principal.toString()}));
                }
            }
        };
    }
}

