/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.notifications;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.template.put.TransportPutComposableIndexTemplateAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditor;
import org.elasticsearch.xpack.core.transform.TransformConfigVersion;
import org.elasticsearch.xpack.core.transform.TransformMetadata;
import org.elasticsearch.xpack.core.transform.notifications.TransformAuditMessage;
import org.elasticsearch.xpack.transform.persistence.TransformInternalIndex;

public class TransformAuditor
extends AbstractAuditor<TransformAuditMessage> {
    private static final Logger logger = LogManager.getLogger(TransformAuditor.class);
    private volatile boolean isResetMode = false;
    private final boolean includeNodeInfo;

    public TransformAuditor(Client client, String nodeName, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, boolean includeNodeInfo) {
        super(new OriginSettingClient(client, "transform"), ".transform-notifications-write", nodeName, TransformAuditMessage::new, clusterService, indexNameExpressionResolver, clusterService.threadPool().generic());
        clusterService.addListener(event -> {
            if (event.metadataChanged()) {
                boolean oldIsResetMode = this.isResetMode;
                boolean newIsResetMode = TransformMetadata.getTransformMetadata((ClusterState)event.state()).resetMode();
                if (oldIsResetMode != newIsResetMode) {
                    logger.debug("TransformAuditor has noticed change of isResetMode bit from {} to {}", (Object)oldIsResetMode, (Object)newIsResetMode);
                }
                this.isResetMode = newIsResetMode;
            }
        });
        this.includeNodeInfo = includeNodeInfo;
    }

    public boolean isIncludeNodeInfo() {
        return this.includeNodeInfo;
    }

    protected void indexDoc(ToXContent toXContent) {
        if (!this.isResetMode) {
            super.indexDoc(toXContent);
        }
    }

    protected void writeBacklog() {
        if (this.isResetMode) {
            this.clearBacklog();
        } else {
            super.writeBacklog();
        }
    }

    protected TransportPutComposableIndexTemplateAction.Request putTemplateRequest() {
        try {
            return new TransportPutComposableIndexTemplateAction.Request(".transform-notifications-000002").indexTemplate(ComposableIndexTemplate.builder().template(TransformInternalIndex.getAuditIndexTemplate()).version(Long.valueOf(TransformConfigVersion.CURRENT.id())).indexPatterns(List.of(".transform-notifications-*")).priority(Long.valueOf(Long.MAX_VALUE)).build());
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failure creating transform notification index template request", (Throwable)e, new Object[0]);
        }
    }

    protected int templateVersion() {
        return TransformConfigVersion.CURRENT.id();
    }

    protected AbstractAuditor.IndexDetails indexDetails() {
        return new AbstractAuditor.IndexDetails(".transform-notifications-", "000002");
    }
}

