/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.painless.lookup.PainlessClassBinding;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class PainlessContextClassBindingInfo
implements Writeable,
ToXContentObject {
    public static final ParseField DECLARING = new ParseField("declaring", new String[0]);
    public static final ParseField NAME = new ParseField("name", new String[0]);
    public static final ParseField RTN = new ParseField("return", new String[0]);
    public static final ParseField READ_ONLY = new ParseField("read_only", new String[0]);
    public static final ParseField PARAMETERS = new ParseField("parameters", new String[0]);
    private static final ConstructingObjectParser<PainlessContextClassBindingInfo, Void> PARSER = new ConstructingObjectParser(PainlessContextClassBindingInfo.class.getCanonicalName(), v -> new PainlessContextClassBindingInfo((String)v[0], (String)v[1], (String)v[2], (Integer)v[3], (List)v[4]));
    private final String declaring;
    private final String name;
    private final String rtn;
    private final int readOnly;
    private final List<String> parameters;

    public PainlessContextClassBindingInfo(PainlessClassBinding painlessClassBinding) {
        this(painlessClassBinding.javaMethod().getDeclaringClass().getName(), painlessClassBinding.javaMethod().getName(), painlessClassBinding.returnType().getName(), painlessClassBinding.javaConstructor().getParameterCount(), painlessClassBinding.typeParameters().stream().map(Class::getName).collect(Collectors.toList()));
    }

    public PainlessContextClassBindingInfo(String declaring, String name, String rtn, int readOnly, List<String> parameters) {
        this.declaring = Objects.requireNonNull(declaring);
        this.name = Objects.requireNonNull(name);
        this.rtn = Objects.requireNonNull(rtn);
        this.readOnly = readOnly;
        this.parameters = Collections.unmodifiableList(Objects.requireNonNull(parameters));
    }

    public PainlessContextClassBindingInfo(StreamInput in) throws IOException {
        this.declaring = in.readString();
        this.name = in.readString();
        this.rtn = in.readString();
        this.readOnly = in.readInt();
        this.parameters = in.readCollectionAsImmutableList(StreamInput::readString);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.declaring);
        out.writeString(this.name);
        out.writeString(this.rtn);
        out.writeInt(this.readOnly);
        out.writeStringCollection(this.parameters);
    }

    public static PainlessContextClassBindingInfo fromXContent(XContentParser parser) {
        return (PainlessContextClassBindingInfo)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DECLARING.getPreferredName(), this.declaring);
        builder.field(NAME.getPreferredName(), this.name);
        builder.field(RTN.getPreferredName(), this.rtn);
        builder.field(READ_ONLY.getPreferredName(), this.readOnly);
        builder.field(PARAMETERS.getPreferredName(), this.parameters);
        builder.endObject();
        return builder;
    }

    public String getSortValue() {
        return PainlessLookupUtility.buildPainlessMethodKey(this.name, this.parameters.size());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PainlessContextClassBindingInfo that = (PainlessContextClassBindingInfo)o;
        return this.readOnly == that.readOnly && Objects.equals(this.declaring, that.declaring) && Objects.equals(this.name, that.name) && Objects.equals(this.rtn, that.rtn) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.declaring, this.name, this.rtn, this.readOnly, this.parameters);
    }

    public String toString() {
        return "PainlessContextClassBindingInfo{declaring='" + this.declaring + "', name='" + this.name + "', rtn='" + this.rtn + "', readOnly=" + this.readOnly + ", parameters=" + String.valueOf(this.parameters) + "}";
    }

    public String getDeclaring() {
        return this.declaring;
    }

    public String getName() {
        return this.name;
    }

    public String getRtn() {
        return this.rtn;
    }

    public int getReadOnly() {
        return this.readOnly;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DECLARING);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), RTN);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), READ_ONLY);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), PARAMETERS);
    }
}

