/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.core.watcher.transport.actions.activate.ActivateWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.activate.ActivateWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.activate.ActivateWatchResponse;
import org.elasticsearch.xpack.core.watcher.watch.WatchField;

public class RestActivateWatchAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_watcher/watch/{id}/_activate"), new RestHandler.Route(RestRequest.Method.PUT, "/_watcher/watch/{id}/_activate"));
    }

    public String getName() {
        return "watcher_activate_watch";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        String watchId = request.param("id");
        return channel -> client.execute((ActionType)ActivateWatchAction.INSTANCE, (ActionRequest)new ActivateWatchRequest(watchId, true), (ActionListener)new RestBuilderListener<ActivateWatchResponse>(this, channel){

            public RestResponse buildResponse(ActivateWatchResponse response, XContentBuilder builder) throws Exception {
                return new RestResponse(RestStatus.OK, builder.startObject().field(WatchField.STATUS.getPreferredName(), (ToXContent)response.getStatus(), (ToXContent.Params)WatcherParams.HIDE_SECRETS).endObject());
            }
        });
    }

    public static class DeactivateRestHandler
    extends BaseRestHandler {
        public List<RestHandler.Route> routes() {
            return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_watcher/watch/{id}/_deactivate"), new RestHandler.Route(RestRequest.Method.PUT, "/_watcher/watch/{id}/_deactivate"));
        }

        public String getName() {
            return "watcher_deactivate_watch";
        }

        public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
            String watchId = request.param("id");
            return channel -> client.execute((ActionType)ActivateWatchAction.INSTANCE, (ActionRequest)new ActivateWatchRequest(watchId, false), (ActionListener)new RestBuilderListener<ActivateWatchResponse>(this, channel){

                public RestResponse buildResponse(ActivateWatchResponse response, XContentBuilder builder) throws Exception {
                    return new RestResponse(RestStatus.OK, builder.startObject().field(WatchField.STATUS.getPreferredName(), (ToXContent)response.getStatus(), (ToXContent.Params)WatcherParams.HIDE_SECRETS).endObject());
                }
            });
        }
    }
}

