/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.index;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.actions.ActionFactory;
import org.elasticsearch.xpack.watcher.actions.index.ExecutableIndexAction;
import org.elasticsearch.xpack.watcher.actions.index.IndexAction;

public class IndexActionFactory
extends ActionFactory {
    private final Client client;
    private final TimeValue indexDefaultTimeout;
    private final TimeValue bulkDefaultTimeout;

    public IndexActionFactory(Settings settings, Client client) {
        super(LogManager.getLogger(IndexActionFactory.class));
        this.client = client;
        this.indexDefaultTimeout = settings.getAsTime("xpack.watcher.actions.index.default_timeout", TimeValue.timeValueSeconds((long)30L));
        this.bulkDefaultTimeout = settings.getAsTime("xpack.watcher.actions.bulk.default_timeout", TimeValue.timeValueMinutes((long)1L));
    }

    public ExecutableIndexAction parseExecutable(String watchId, String actionId, XContentParser parser) throws IOException {
        return new ExecutableIndexAction(IndexAction.parse(watchId, actionId, parser), this.actionLogger, this.client, this.indexDefaultTimeout, this.bulkDefaultTimeout);
    }
}

