/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.action.ILMActions;
import org.elasticsearch.xpack.ilm.IndexLifecycleService;

public class TransportMoveToStepAction
extends TransportMasterNodeAction<Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportMoveToStepAction.class);
    private final IndexLifecycleService indexLifecycleService;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportMoveToStepAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexLifecycleService indexLifecycleService, ProjectResolver projectResolver) {
        super(ILMActions.MOVE_TO_STEP.name(), transportService, clusterService, threadPool, actionFilters, Request::new, AcknowledgedResponse::readFrom, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.indexLifecycleService = indexLifecycleService;
        this.projectResolver = projectResolver;
    }

    protected void masterOperation(Task task, final Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        final ProjectMetadata project = this.projectResolver.getProjectMetadata(state);
        final IndexMetadata indexMetadata = project.index(request.getIndex());
        if (indexMetadata == null) {
            listener.onFailure((Exception)new IllegalArgumentException("index [" + request.getIndex() + "] does not exist"));
            return;
        }
        String policyName = indexMetadata.getLifecyclePolicyName();
        if (policyName == null) {
            listener.onFailure((Exception)new IllegalArgumentException("index [" + request.getIndex() + "] is not associated with an Index Lifecycle Policy"));
            return;
        }
        final Request.PartialStepKey abstractTargetKey = request.getNextStepKey();
        String targetStr = abstractTargetKey.getPhase() + "/" + abstractTargetKey.getAction() + "/" + abstractTargetKey.getName();
        Step.StepKey concreteTargetStepKey = this.indexLifecycleService.resolveStepKey(project, indexMetadata.getIndex(), abstractTargetKey.getPhase(), abstractTargetKey.getAction(), abstractTargetKey.getName());
        if (concreteTargetStepKey == null) {
            String message = "cannot move index [" + indexMetadata.getIndex().getName() + "] with policy [" + policyName + "]: unable to determine concrete step key from target next step key: " + String.valueOf(abstractTargetKey);
            logger.warn(message);
            listener.onFailure((Exception)new IllegalArgumentException(message));
            return;
        }
        this.submitUnbatchedTask("index[" + request.getIndex() + "]-move-to-step-" + targetStr, (ClusterStateUpdateTask)new AckedClusterStateUpdateTask(request, listener){
            final SetOnce<Step.StepKey> concreteTargetKey;
            {
                super(arg0, arg1);
                this.concreteTargetKey = new SetOnce();
            }

            public ClusterState execute(ClusterState currentState) {
                ProjectMetadata currentProject = currentState.metadata().getProject(project.id());
                Step.StepKey concreteTargetStepKey = TransportMoveToStepAction.this.indexLifecycleService.resolveStepKey(currentProject, indexMetadata.getIndex(), abstractTargetKey.getPhase(), abstractTargetKey.getAction(), abstractTargetKey.getName());
                if (concreteTargetStepKey == null) {
                    logger.error("unable to move index " + String.valueOf(indexMetadata.getIndex()) + " as we are unable to resolve a concrete step key from target next step key: " + String.valueOf(abstractTargetKey));
                    return currentState;
                }
                this.concreteTargetKey.set((Object)concreteTargetStepKey);
                ProjectMetadata updatedProject = TransportMoveToStepAction.this.indexLifecycleService.moveIndexToStep(currentProject, indexMetadata.getIndex(), request.getCurrentStepKey(), (Step.StepKey)this.concreteTargetKey.get());
                return ClusterState.builder((ClusterState)currentState).putProjectMetadata(updatedProject).build();
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                ProjectState newProjectState = newState.projectState(project.id());
                IndexMetadata newIndexMetadata = newProjectState.metadata().index(indexMetadata.getIndex());
                if (newIndexMetadata == null) {
                    logger.debug("index [" + String.valueOf(indexMetadata.getIndex()) + "] has been deleted after moving to step [" + String.valueOf(this.concreteTargetKey.get()) + "], skipping async action check");
                    return;
                }
                TransportMoveToStepAction.this.indexLifecycleService.maybeRunAsyncAction(newProjectState, newIndexMetadata, (Step.StepKey)this.concreteTargetKey.get());
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    protected ClusterBlockException checkBlock(Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        static final ParseField CURRENT_KEY_FIELD = new ParseField("current_step", new String[0]);
        static final ParseField NEXT_KEY_FIELD = new ParseField("next_step", new String[0]);
        private static final ConstructingObjectParser<Request, Factory> PARSER = new ConstructingObjectParser("move_to_step_request", false, (a, factory) -> {
            Step.StepKey currentStepKey = (Step.StepKey)a[0];
            PartialStepKey nextStepKey = (PartialStepKey)a[1];
            return factory.create(currentStepKey, nextStepKey);
        });
        private final String index;
        private final Step.StepKey currentStepKey;
        private final PartialStepKey nextStepKey;

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, String index, Step.StepKey currentStepKey, PartialStepKey nextStepKey) {
            super(masterNodeTimeout, ackTimeout);
            this.index = index;
            this.currentStepKey = currentStepKey;
            this.nextStepKey = nextStepKey;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.index = in.readString();
            this.currentStepKey = Step.StepKey.readFrom((StreamInput)in);
            this.nextStepKey = new PartialStepKey(in);
        }

        public String getIndex() {
            return this.index;
        }

        public Step.StepKey getCurrentStepKey() {
            return this.currentStepKey;
        }

        public PartialStepKey getNextStepKey() {
            return this.nextStepKey;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public static Request parseRequest(Factory factory, XContentParser parser) {
            return (Request)((Object)PARSER.apply(parser, (Object)factory));
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
            this.currentStepKey.writeTo(out);
            this.nextStepKey.writeTo(out);
        }

        public int hashCode() {
            return Objects.hash(this.index, this.currentStepKey, this.nextStepKey);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.index, other.index) && Objects.equals(this.currentStepKey, other.currentStepKey) && Objects.equals(this.nextStepKey, other.nextStepKey);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(CURRENT_KEY_FIELD.getPreferredName(), (ToXContent)this.currentStepKey).field(NEXT_KEY_FIELD.getPreferredName(), (ToXContent)this.nextStepKey).endObject();
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, name) -> Step.StepKey.parse((XContentParser)p), CURRENT_KEY_FIELD);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, name) -> PartialStepKey.parse(p), NEXT_KEY_FIELD);
        }

        public static class PartialStepKey
        implements Writeable,
        ToXContentObject {
            private final String phase;
            private final String action;
            private final String name;
            public static final ParseField PHASE_FIELD = new ParseField("phase", new String[0]);
            public static final ParseField ACTION_FIELD = new ParseField("action", new String[0]);
            public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
            private static final ConstructingObjectParser<PartialStepKey, Void> PARSER = new ConstructingObjectParser("step_specification", a -> new PartialStepKey((String)a[0], (String)a[1], (String)a[2]));

            public PartialStepKey(String phase, @Nullable String action, @Nullable String name) {
                this.phase = phase;
                this.action = action;
                this.name = name;
                if (name != null && action == null) {
                    throw new IllegalArgumentException("phase; phase and action; or phase, action, and step must be provided, but a step name was specified without a corresponding action");
                }
            }

            public PartialStepKey(StreamInput in) throws IOException {
                this.phase = in.readString();
                this.action = in.readOptionalString();
                this.name = in.readOptionalString();
                if (this.name != null && this.action == null) {
                    throw new IllegalArgumentException("phase; phase and action; or phase, action, and step must be provided, but a step name was specified without a corresponding action");
                }
            }

            public static PartialStepKey parse(XContentParser parser) {
                return (PartialStepKey)PARSER.apply(parser, null);
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.phase);
                out.writeOptionalString(this.action);
                out.writeOptionalString(this.name);
            }

            @Nullable
            public String getPhase() {
                return this.phase;
            }

            @Nullable
            public String getAction() {
                return this.action;
            }

            @Nullable
            public String getName() {
                return this.name;
            }

            public int hashCode() {
                return Objects.hash(this.phase, this.action, this.name);
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                PartialStepKey other = (PartialStepKey)obj;
                return Objects.equals(this.phase, other.phase) && Objects.equals(this.action, other.action) && Objects.equals(this.name, other.name);
            }

            public String toString() {
                return Strings.toString((ToXContent)this);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(PHASE_FIELD.getPreferredName(), this.phase);
                if (this.action != null) {
                    builder.field(ACTION_FIELD.getPreferredName(), this.action);
                }
                if (this.name != null) {
                    builder.field(NAME_FIELD.getPreferredName(), this.name);
                }
                builder.endObject();
                return builder;
            }

            static {
                PARSER.declareString(ConstructingObjectParser.constructorArg(), PHASE_FIELD);
                PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ACTION_FIELD);
                PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), NAME_FIELD);
            }
        }

        public static interface Factory {
            public Request create(Step.StepKey var1, PartialStepKey var2);
        }
    }
}

