/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.normalizer;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.results.Influencer;
import org.elasticsearch.xpack.ml.job.process.normalizer.AbstractLeafNormalizable;
import org.elasticsearch.xpack.ml.job.process.normalizer.Level;

class InfluencerNormalizable
extends AbstractLeafNormalizable {
    private final Influencer influencer;

    InfluencerNormalizable(Influencer influencer, String indexName) {
        super(indexName);
        this.influencer = Objects.requireNonNull(influencer);
    }

    @Override
    public String getId() {
        return this.influencer.getId();
    }

    @Override
    public Level getLevel() {
        return Level.INFLUENCER;
    }

    @Override
    public String getPartitionFieldName() {
        return null;
    }

    @Override
    public String getPartitionFieldValue() {
        return null;
    }

    @Override
    public String getPersonFieldName() {
        return this.influencer.getInfluencerFieldName();
    }

    @Override
    public String getPersonFieldValue() {
        return this.influencer.getInfluencerFieldValue();
    }

    @Override
    public String getFunctionName() {
        return null;
    }

    @Override
    public String getValueFieldName() {
        return null;
    }

    @Override
    public double getProbability() {
        return this.influencer.getProbability();
    }

    @Override
    public double getNormalizedScore() {
        return this.influencer.getInfluencerScore();
    }

    @Override
    public void setNormalizedScore(double normalizedScore) {
        this.influencer.setInfluencerScore(normalizedScore);
    }

    @Override
    public void setParentScore(double parentScore) {
        throw new IllegalStateException("Influencer has no parent");
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.influencer.toXContent(builder, params);
    }
}

