/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.assignment;

import java.util.Objects;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.action.DeleteTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.action.UpdateTrainedModelAssignmentRoutingInfoAction;
import org.elasticsearch.xpack.core.ml.inference.ModelDeploymentTimeoutException;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignment;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignmentMetadata;

public class TrainedModelAssignmentService {
    private static final Logger logger = LogManager.getLogger(TrainedModelAssignmentService.class);
    private final Client client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private static final Class<?>[] MASTER_CHANNEL_EXCEPTIONS = new Class[]{NotMasterException.class, ConnectTransportException.class, FailedToCommitClusterStateException.class};

    public TrainedModelAssignmentService(Client client, ClusterService clusterService, ThreadPool threadPool) {
        this.client = new OriginSettingClient(client, "ml");
        this.clusterService = Objects.requireNonNull(clusterService);
        this.threadPool = Objects.requireNonNull(threadPool);
    }

    public void updateModelAssignmentState(UpdateTrainedModelAssignmentRoutingInfoAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        ClusterState currentState = this.clusterService.state();
        ClusterStateObserver observer = new ClusterStateObserver(currentState, this.clusterService, null, logger, this.threadPool.getThreadContext());
        DiscoveryNode masterNode = currentState.nodes().getMasterNode();
        if (masterNode == null) {
            logger.warn("[{}] no master known for assignment update [{}]", (Object)request.getDeploymentId(), (Object)request.getUpdate());
            this.waitForNewMasterAndRetry(observer, (ActionType<AcknowledgedResponse>)UpdateTrainedModelAssignmentRoutingInfoAction.INSTANCE, (ActionRequest)request, listener);
            return;
        }
        this.client.execute((ActionType)UpdateTrainedModelAssignmentRoutingInfoAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), failure -> {
            if (TrainedModelAssignmentService.isMasterChannelException(failure)) {
                logger.info("[{}] master channel exception will retry on new master node for assignment update [{}]", (Object)request.getDeploymentId(), (Object)request.getUpdate());
                this.waitForNewMasterAndRetry(observer, (ActionType<AcknowledgedResponse>)UpdateTrainedModelAssignmentRoutingInfoAction.INSTANCE, (ActionRequest)request, listener);
                return;
            }
            listener.onFailure(failure);
        }));
    }

    public void createNewModelAssignment(CreateTrainedModelAssignmentAction.Request request, ActionListener<CreateTrainedModelAssignmentAction.Response> listener) {
        this.client.execute((ActionType)CreateTrainedModelAssignmentAction.INSTANCE, (ActionRequest)request, listener);
    }

    public void deleteModelAssignment(String modelId, ActionListener<AcknowledgedResponse> listener) {
        this.client.execute((ActionType)DeleteTrainedModelAssignmentAction.INSTANCE, (ActionRequest)new DeleteTrainedModelAssignmentAction.Request(modelId), listener);
    }

    public void waitForAssignmentCondition(final String deploymentId, Predicate<ClusterState> predicate, @Nullable TimeValue timeout, final WaitForAssignmentListener listener) {
        ClusterStateObserver.waitForState((ClusterService)this.clusterService, (ThreadContext)this.threadPool.getThreadContext(), (ClusterStateObserver.Listener)new ClusterStateObserver.Listener(){

            public void onNewClusterState(ClusterState state) {
                listener.onResponse(TrainedModelAssignmentMetadata.assignmentForDeploymentId((ClusterState)state, (String)deploymentId).orElse(null));
            }

            public void onClusterServiceClose() {
                listener.onFailure((Exception)new NodeClosedException(TrainedModelAssignmentService.this.clusterService.localNode()));
            }

            public void onTimeout(TimeValue timeout) {
                listener.onTimeout(timeout);
            }
        }, predicate, (TimeValue)timeout, (Logger)logger);
    }

    protected void waitForNewMasterAndRetry(ClusterStateObserver observer, final ActionType<AcknowledgedResponse> action, final ActionRequest request, final ActionListener<AcknowledgedResponse> listener) {
        observer.waitForNextChange(new ClusterStateObserver.Listener(){

            public void onNewClusterState(ClusterState state) {
                TrainedModelAssignmentService.this.client.execute(action, request, listener);
            }

            public void onClusterServiceClose() {
                logger.warn("node closed while execution action [{}] for request [{}]", (Object)action.name(), (Object)request);
                listener.onFailure((Exception)new NodeClosedException(TrainedModelAssignmentService.this.clusterService.localNode()));
            }

            public void onTimeout(TimeValue timeout) {
                assert (false);
            }
        }, ClusterStateObserver.NON_NULL_MASTER_PREDICATE);
    }

    private static boolean isMasterChannelException(Exception exp) {
        return ExceptionsHelper.unwrap((Throwable)exp, (Class[])MASTER_CHANNEL_EXCEPTIONS) != null;
    }

    public static interface WaitForAssignmentListener
    extends ActionListener<TrainedModelAssignment> {
        default public void onTimeout(TimeValue timeout) {
            this.onFailure((Exception)new ModelDeploymentTimeoutException(Strings.format((String)"Timed out after [%s] waiting for trained model deployment to start. Use the trained model stats API to track the state of the deployment and try again once it has started.", (Object[])new Object[]{timeout})));
        }
    }
}

