/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.autoscaling;

import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Processors;
import org.elasticsearch.common.xcontent.XContentElasticsearchExtension;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderContext;
import org.elasticsearch.xpack.core.ml.inference.assignment.Priority;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignment;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignmentMetadata;
import org.elasticsearch.xpack.ml.autoscaling.MlAutoscalingContext;
import org.elasticsearch.xpack.ml.autoscaling.MlAutoscalingDeciderService;
import org.elasticsearch.xpack.ml.autoscaling.MlMemoryAutoscalingDecider;
import org.elasticsearch.xpack.ml.autoscaling.MlProcessorAutoscalingCapacity;
import org.elasticsearch.xpack.ml.autoscaling.ScaleTimer;
import org.elasticsearch.xpack.ml.utils.MlProcessors;

class MlProcessorAutoscalingDecider {
    private static final Logger logger = LogManager.getLogger(MlProcessorAutoscalingDecider.class);
    private final ScaleTimer scaleTimer;

    MlProcessorAutoscalingDecider(ScaleTimer scaleTimer) {
        this.scaleTimer = Objects.requireNonNull(scaleTimer);
    }

    public MlProcessorAutoscalingCapacity scale(Settings configuration, AutoscalingDeciderContext context, MlAutoscalingContext mlContext, int allocatedProcessorsScale) {
        TrainedModelAssignmentMetadata trainedModelAssignmentMetadata = TrainedModelAssignmentMetadata.fromState((ClusterState)context.state());
        if (MlProcessorAutoscalingDecider.hasUnsatisfiedDeployments(trainedModelAssignmentMetadata, mlContext.mlNodes)) {
            logger.debug(() -> "Computing required capacity as there are partially allocated deployments");
            this.scaleTimer.resetScaleDownCoolDown();
            return MlProcessorAutoscalingDecider.computeRequiredCapacity(trainedModelAssignmentMetadata).setReason("requesting scale up as there are unsatisfied deployments").build();
        }
        MlProcessorAutoscalingCapacity currentCapacity = this.computeCurrentCapacity(mlContext.mlNodes, allocatedProcessorsScale);
        MlProcessorAutoscalingCapacity requiredCapacity = MlProcessorAutoscalingDecider.computeRequiredCapacity(trainedModelAssignmentMetadata).build();
        if (requiredCapacity.tierProcessors().roundUp() == currentCapacity.tierProcessors().roundUp()) {
            return MlProcessorAutoscalingCapacity.builder(currentCapacity.nodeProcessors(), currentCapacity.tierProcessors()).setReason("passing currently perceived capacity as it is fully used").build();
        }
        if (MlMemoryAutoscalingDecider.modelAssignmentsRequireMoreThanHalfCpu(trainedModelAssignmentMetadata.allAssignments().values(), mlContext.mlNodes, allocatedProcessorsScale)) {
            return MlProcessorAutoscalingCapacity.builder(currentCapacity.nodeProcessors(), currentCapacity.tierProcessors()).setReason("not scaling down as model assignments require more than half of the ML tier's allocated processors").build();
        }
        long msLeftToScale = this.scaleTimer.markDownScaleAndGetMillisLeftFromDelay(configuration);
        if (msLeftToScale <= 0L) {
            return MlProcessorAutoscalingCapacity.builder(requiredCapacity.nodeProcessors(), requiredCapacity.tierProcessors()).setReason("requesting scale down as tier and/or node size could be smaller").build();
        }
        TimeValue downScaleDelay = (TimeValue)MlAutoscalingDeciderService.DOWN_SCALE_DELAY.get(configuration);
        logger.debug(() -> Strings.format((String)"not scaling down as the current scale down delay [%s] is not satisfied. The last time scale down was detected [%s]. Calculated scaled down capacity [%s] ", (Object[])new Object[]{downScaleDelay.getStringRep(), XContentElasticsearchExtension.DEFAULT_FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli(this.scaleTimer.downScaleDetectedMillis())), requiredCapacity}));
        return MlProcessorAutoscalingCapacity.builder(currentCapacity.nodeProcessors(), currentCapacity.tierProcessors()).setReason(String.format(Locale.ROOT, "Passing currently perceived capacity as down scale delay has not been satisfied; configured delay [%s] last detected scale down event [%s]. Will request scale down in approximately [%s]", downScaleDelay.getStringRep(), XContentElasticsearchExtension.DEFAULT_FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli(this.scaleTimer.downScaleDetectedMillis())), TimeValue.timeValueMillis((long)msLeftToScale).getStringRep())).build();
    }

    private static boolean hasUnsatisfiedDeployments(TrainedModelAssignmentMetadata trainedModelAssignmentMetadata, List<DiscoveryNode> mlNodes) {
        Set mlNodeIds = mlNodes.stream().map(DiscoveryNode::getId).collect(Collectors.toSet());
        return trainedModelAssignmentMetadata.allAssignments().values().stream().filter(deployment -> deployment.getTaskParams().getPriority() == Priority.NORMAL).anyMatch(deployment -> !deployment.isSatisfied(mlNodeIds));
    }

    private static MlProcessorAutoscalingCapacity.Builder computeRequiredCapacity(TrainedModelAssignmentMetadata trainedModelAssignmentMetadata) {
        int maxThreadsPerAllocation = 0;
        double processorCount = 0.0;
        boolean hasLowPriorityDeployments = false;
        for (TrainedModelAssignment assignment : trainedModelAssignmentMetadata.allAssignments().values()) {
            if (assignment.getTaskParams().getPriority() == Priority.LOW) {
                hasLowPriorityDeployments = true;
                continue;
            }
            int threadsPerAllocation = assignment.getTaskParams().getThreadsPerAllocation();
            maxThreadsPerAllocation = Math.max(maxThreadsPerAllocation, threadsPerAllocation);
            processorCount += (double)(assignment.getTaskParams().getNumberOfAllocations() * threadsPerAllocation);
        }
        if (hasLowPriorityDeployments) {
            processorCount = Math.max(0.1, processorCount);
        }
        return MlProcessorAutoscalingCapacity.builder(maxThreadsPerAllocation > 0 ? Processors.of((Double)Double.valueOf(maxThreadsPerAllocation)) : Processors.ZERO, processorCount > 0.0 ? Processors.of((Double)processorCount) : Processors.ZERO);
    }

    MlProcessorAutoscalingCapacity computeCurrentCapacity(List<DiscoveryNode> mlNodes, int allocatedProcessorsScale) {
        Processors maxNodeProcessors = Processors.ZERO;
        Processors tierProcessors = Processors.ZERO;
        for (DiscoveryNode node : mlNodes) {
            Processors nodeProcessors = MlProcessors.get(node, allocatedProcessorsScale);
            if (nodeProcessors.compareTo(maxNodeProcessors) > 0) {
                maxNodeProcessors = nodeProcessors;
            }
            tierProcessors = tierProcessors.plus(nodeProcessors);
        }
        return MlProcessorAutoscalingCapacity.builder(maxNodeProcessors, tierProcessors).build();
    }
}

