/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;

public final class UserAgentUtil {
    private static final int MAX_APPLICATION_ID_LENGTH = 24;
    private static final String INVALID_APPLICATION_ID_LENGTH = "'applicationId' length cannot be greater than 24";
    private static final String INVALID_APPLICATION_ID_SPACE = "'applicationId' cannot contain spaces.";
    public static final String DEFAULT_USER_AGENT_HEADER = "azsdk-java";
    private static final String PLATFORM_INFO_FORMAT = "%s; %s; %s";
    private static final int MAX_APP_ID_LENGTH = 24;

    private UserAgentUtil() {
    }

    public static String toUserAgentString(String applicationId, String sdkName, String sdkVersion, Configuration configuration) {
        StringBuilder userAgentBuilder = new StringBuilder();
        if (!CoreUtils.isNullOrEmpty(applicationId)) {
            if (applicationId.length() > 24) {
                throw new IllegalArgumentException(INVALID_APPLICATION_ID_LENGTH);
            }
            if (applicationId.contains(" ")) {
                throw new IllegalArgumentException(INVALID_APPLICATION_ID_SPACE);
            }
            userAgentBuilder.append(applicationId).append(" ");
        }
        userAgentBuilder.append(DEFAULT_USER_AGENT_HEADER).append("-").append(sdkName).append("/").append(sdkVersion);
        if (!UserAgentUtil.isTelemetryDisabled(configuration)) {
            userAgentBuilder.append(" (").append(UserAgentUtil.getPlatformInfo()).append(")");
        }
        return userAgentBuilder.toString();
    }

    private static String getPlatformInfo() {
        String javaVersion = Configuration.getGlobalConfiguration().get("java.version");
        String osName = Configuration.getGlobalConfiguration().get("os.name");
        String osVersion = Configuration.getGlobalConfiguration().get("os.version");
        return String.format(PLATFORM_INFO_FORMAT, javaVersion, osName, osVersion);
    }

    private static boolean isTelemetryDisabled(Configuration configuration) {
        return configuration == null ? Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", false).booleanValue() : configuration.get("AZURE_TELEMETRY_DISABLED", false).booleanValue();
    }
}

