/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc.codecs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.codecs.TermVectorsFormat;
import org.apache.lucene.codecs.perfield.PerFieldPostingsFormat;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Version;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene80.BWCLucene80Codec;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene84.BWCLucene84Codec;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene86.BWCLucene86Codec;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene87.BWCLucene87Codec;

public abstract class BWCCodec
extends Codec {
    private final FieldInfosFormat fieldInfosFormat = new FieldInfosFormat(){
        final FieldInfosFormat wrappedFormat;
        {
            this.wrappedFormat = BWCCodec.this.originalFieldInfosFormat();
        }

        public FieldInfos read(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, IOContext iocontext) throws IOException {
            return BWCCodec.filterFields(this.wrappedFormat.read(directory, segmentInfo, segmentSuffix, iocontext));
        }

        public void write(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, FieldInfos infos, IOContext context) throws IOException {
            this.wrappedFormat.write(directory, segmentInfo, segmentSuffix, infos, context);
        }
    };
    private final SegmentInfoFormat segmentInfosFormat = new SegmentInfoFormat(){
        final SegmentInfoFormat wrappedFormat;
        {
            this.wrappedFormat = BWCCodec.this.originalSegmentInfoFormat();
        }

        public SegmentInfo read(Directory directory, String segmentName, byte[] segmentID, IOContext context) throws IOException {
            return BWCCodec.wrap(this.wrappedFormat.read(directory, segmentName, segmentID, context));
        }

        public void write(Directory dir, SegmentInfo info, IOContext ioContext) throws IOException {
            this.wrappedFormat.write(dir, info, ioContext);
        }
    };
    private final PostingsFormat postingsFormat = new PerFieldPostingsFormat(this){

        public PostingsFormat getPostingsFormatForField(String field) {
            throw new UnsupportedOperationException("Old codecs can't be used for writing");
        }
    };

    protected BWCCodec(String name) {
        super(name);
    }

    public final FieldInfosFormat fieldInfosFormat() {
        return this.fieldInfosFormat;
    }

    public final SegmentInfoFormat segmentInfoFormat() {
        return this.segmentInfosFormat;
    }

    public PostingsFormat postingsFormat() {
        return this.postingsFormat;
    }

    public final NormsFormat normsFormat() {
        throw new UnsupportedOperationException();
    }

    public final TermVectorsFormat termVectorsFormat() {
        throw new UnsupportedOperationException();
    }

    public final KnnVectorsFormat knnVectorsFormat() {
        throw new UnsupportedOperationException();
    }

    protected abstract SegmentInfoFormat originalSegmentInfoFormat();

    protected abstract FieldInfosFormat originalFieldInfosFormat();

    private static FieldInfos filterFields(FieldInfos fieldInfos) {
        ArrayList<FieldInfo> fieldInfoCopy = new ArrayList<FieldInfo>(fieldInfos.size());
        for (FieldInfo fieldInfo : fieldInfos) {
            fieldInfoCopy.add(new FieldInfo(fieldInfo.name, fieldInfo.number, false, true, false, fieldInfo.getIndexOptions(), fieldInfo.getDocValuesType(), fieldInfo.docValuesSkipIndexType(), fieldInfo.getDocValuesGen(), fieldInfo.attributes(), fieldInfo.getPointDimensionCount(), fieldInfo.getPointIndexDimensionCount(), fieldInfo.getPointNumBytes(), 0, fieldInfo.getVectorEncoding(), fieldInfo.getVectorSimilarityFunction(), fieldInfo.isSoftDeletesField(), fieldInfo.isParentField()));
        }
        FieldInfos newFieldInfos = new FieldInfos(fieldInfoCopy.toArray(new FieldInfo[0]));
        return newFieldInfos;
    }

    public static SegmentInfo wrap(SegmentInfo segmentInfo) {
        Codec codec = BWCCodec.getBackwardCompatibleCodec(segmentInfo.getCodec());
        SegmentInfo segmentInfo1 = new SegmentInfo(segmentInfo.dir, Version.LATEST, Version.LATEST, segmentInfo.name, segmentInfo.maxDoc(), segmentInfo.getUseCompoundFile(), segmentInfo.getHasBlocks(), codec, segmentInfo.getDiagnostics(), segmentInfo.getId(), segmentInfo.getAttributes(), segmentInfo.getIndexSort());
        segmentInfo1.setFiles((Collection)segmentInfo.files());
        return segmentInfo1;
    }

    private static Codec getBackwardCompatibleCodec(Codec codec) {
        if (codec == null) {
            return null;
        }
        return switch (codec.getClass().getSimpleName()) {
            case "Lucene80Codec" -> new BWCLucene80Codec();
            case "Lucene84Codec" -> new BWCLucene84Codec();
            case "Lucene86Codec" -> new BWCLucene86Codec();
            case "Lucene87Codec" -> new BWCLucene87Codec();
            default -> codec;
        };
    }

    public static class EmptyPostingsFormat
    extends PostingsFormat {
        public EmptyPostingsFormat() {
            super("EmptyPostingsFormat");
        }

        public FieldsConsumer fieldsConsumer(SegmentWriteState state) {
            return new FieldsConsumer(this){

                public void write(Fields fields, NormsProducer norms) {
                    throw new UnsupportedOperationException();
                }

                public void close() {
                }
            };
        }

        public FieldsProducer fieldsProducer(SegmentReadState state) {
            return new FieldsProducer(this){

                public void close() {
                }

                public void checkIntegrity() {
                }

                public Iterator<String> iterator() {
                    return null;
                }

                public Terms terms(String field) {
                    return null;
                }

                public int size() {
                    return 0;
                }
            };
        }
    }
}

