/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.SetOnce;
import org.apache.lucene.util.Version;
import org.elasticsearch.Build;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.ReadOnlyEngine;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.EnginePlugin;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotRestoreException;
import org.elasticsearch.snapshots.sourceonly.SourceOnlySnapshotRepository;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.lucene.bwc.ArchiveAllocationDecider;
import org.elasticsearch.xpack.lucene.bwc.ArchiveInfoTransportAction;
import org.elasticsearch.xpack.lucene.bwc.ArchiveUsageTracker;
import org.elasticsearch.xpack.lucene.bwc.ArchiveUsageTransportAction;
import org.elasticsearch.xpack.lucene.bwc.FailShardsOnInvalidLicenseClusterListener;
import org.elasticsearch.xpack.lucene.bwc.OldSegmentInfos;
import org.elasticsearch.xpack.lucene.bwc.codecs.BWCCodec;

public class OldLuceneVersions
extends Plugin
implements IndexStorePlugin,
ClusterPlugin,
RepositoryPlugin,
ActionPlugin,
EnginePlugin {
    public static final LicensedFeature.Momentary ARCHIVE_FEATURE = LicensedFeature.momentary(null, (String)"archive", (License.OperationMode)License.OperationMode.ENTERPRISE);
    private static final IndexVersion MINIMUM_ARCHIVE_VERSION = IndexVersion.fromId((int)5000099);
    private final SetOnce<FailShardsOnInvalidLicenseClusterListener> failShardsListener = new SetOnce();

    public Collection<?> createComponents(Plugin.PluginServices services) {
        ThreadPool threadPool = services.threadPool();
        this.failShardsListener.set((Object)new FailShardsOnInvalidLicenseClusterListener(this.getLicenseState(), services.rerouteService()));
        if (DiscoveryNode.isMasterNode((Settings)services.environment().settings())) {
            ArchiveUsageTracker usageTracker = new ArchiveUsageTracker(this.getLicenseState(), () -> ((ClusterService)services.clusterService()).state());
            threadPool.scheduleWithFixedDelay((Runnable)usageTracker, TimeValue.timeValueMinutes((long)15L), (Executor)threadPool.generic());
        }
        return List.of();
    }

    public List<ActionPlugin.ActionHandler> getActions() {
        return List.of(new ActionPlugin.ActionHandler(XPackUsageFeatureAction.ARCHIVE, ArchiveUsageTransportAction.class), new ActionPlugin.ActionHandler(XPackInfoFeatureAction.ARCHIVE, ArchiveInfoTransportAction.class));
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public Collection<AllocationDecider> createAllocationDeciders(Settings settings, ClusterSettings clusterSettings) {
        return List.of(new ArchiveAllocationDecider(() -> ARCHIVE_FEATURE.checkWithoutTracking(this.getLicenseState())));
    }

    public void onIndexModule(IndexModule indexModule) {
        if (indexModule.indexSettings().getIndexVersionCreated().isLegacyIndexVersion()) {
            indexModule.addIndexEventListener(new IndexEventListener(this){

                public void afterFilesRestoredFromRepository(IndexShard indexShard) {
                    OldLuceneVersions.convertToNewFormat(indexShard);
                }
            });
            indexModule.addIndexEventListener((IndexEventListener)this.failShardsListener.get());
            indexModule.addSettingsUpdateConsumer(IndexMetadata.INDEX_BLOCKS_WRITE_SETTING, s -> {}, write -> {
                if (!write.booleanValue()) {
                    throw new IllegalArgumentException("Cannot remove write block from archive index");
                }
            });
        }
    }

    public BiConsumer<Snapshot, IndexVersion> addPreRestoreVersionCheck() {
        return (snapshot, version) -> {
            if (version.isLegacyIndexVersion()) {
                if (!ARCHIVE_FEATURE.checkWithoutTracking(this.getLicenseState())) {
                    throw LicenseUtils.newComplianceException((String)"archive");
                }
                if (version.before((VersionId)MINIMUM_ARCHIVE_VERSION)) {
                    throw new SnapshotRestoreException(snapshot, "the snapshot has indices of version [" + String.valueOf(version) + "] which isn't supported by the archive functionality");
                }
            }
        };
    }

    private static void convertToNewFormat(IndexShard indexShard) {
        indexShard.store().incRef();
        try {
            OldSegmentInfos oldSegmentInfos = OldSegmentInfos.readLatestCommit(indexShard.store().directory(), 6);
            SegmentInfos segmentInfos = OldLuceneVersions.convertToNewerLuceneVersion(oldSegmentInfos);
            segmentInfos.commit(indexShard.store().directory());
            assert (SegmentInfos.readLatestCommit((Directory)indexShard.store().directory()) != null);
            Lucene.pruneUnreferencedFiles((String)segmentInfos.getSegmentsFileName(), (Directory)indexShard.store().directory());
        }
        catch (IOException e) {
            throw new UncheckedIOException(Strings.format((String)"Elasticsearch version [%s] has limited support for indices created with version [%s] but this index could not be read. It may be using an unsupported feature, or it may be damaged or corrupt. See %s for further information.", (Object[])new Object[]{Build.current().version(), IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(indexShard.indexSettings().getSettings()), ReferenceDocs.ARCHIVE_INDICES}), e);
        }
        finally {
            indexShard.store().decRef();
        }
    }

    private static SegmentInfos convertToNewerLuceneVersion(OldSegmentInfos oldSegmentInfos) {
        SegmentInfos segmentInfos = new SegmentInfos(Version.LATEST.major);
        segmentInfos.version = oldSegmentInfos.version;
        segmentInfos.counter = oldSegmentInfos.counter;
        segmentInfos.setNextWriteGeneration(oldSegmentInfos.getGeneration() + 1L);
        HashMap<String, String> map = new HashMap<String, String>(oldSegmentInfos.getUserData());
        if (!map.containsKey("history_uuid")) {
            map.put("history_uuid", UUIDs.randomBase64UUID());
        }
        if (!map.containsKey("local_checkpoint")) {
            map.put("local_checkpoint", Long.toString(-1L));
        }
        if (!map.containsKey("max_seq_no")) {
            map.put("max_seq_no", Long.toString(-1L));
        }
        if (!map.containsKey("max_unsafe_auto_id_timestamp")) {
            map.put("max_unsafe_auto_id_timestamp", "-1");
        }
        if (!map.containsKey("es_version")) {
            assert (!oldSegmentInfos.getLuceneVersion().onOrAfter(RecoverySettings.SEQ_NO_SNAPSHOT_RECOVERIES_SUPPORTED_VERSION.luceneVersion())) : String.valueOf(oldSegmentInfos.getLuceneVersion()) + " should contain the ES_VERSION";
            map.put("es_version", IndexVersions.MINIMUM_COMPATIBLE.toString());
        }
        segmentInfos.setUserData(map, false);
        for (SegmentCommitInfo infoPerCommit : oldSegmentInfos.asList()) {
            SegmentInfo newInfo = BWCCodec.wrap(infoPerCommit.info);
            SegmentCommitInfo commitInfo = new SegmentCommitInfo(newInfo, infoPerCommit.getDelCount(), infoPerCommit.getSoftDelCount(), infoPerCommit.getDelGen(), infoPerCommit.getFieldInfosGen(), infoPerCommit.getDocValuesGen(), infoPerCommit.getId());
            commitInfo.setDocValuesUpdatesFiles(infoPerCommit.getDocValuesUpdatesFiles());
            commitInfo.setFieldInfosFiles(infoPerCommit.getFieldInfosFiles());
            segmentInfos.add(commitInfo);
        }
        return segmentInfos;
    }

    public Map<String, IndexStorePlugin.DirectoryFactory> getDirectoryFactories() {
        return Map.of();
    }

    public Optional<EngineFactory> getEngineFactory(IndexSettings indexSettings) {
        if (indexSettings.getIndexVersionCreated().isLegacyIndexVersion() && !indexSettings.getIndexMetadata().isSearchableSnapshot() && !((Boolean)indexSettings.getValue(SourceOnlySnapshotRepository.SOURCE_ONLY)).booleanValue()) {
            return Optional.of(engineConfig -> new ReadOnlyEngine(engineConfig, null, new TranslogStats(), true, Function.identity(), true, false));
        }
        return Optional.empty();
    }
}

