/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xpack.core.ilm.LifecycleOperationMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleStats;
import org.elasticsearch.xpack.slm.SnapshotRetentionTask;

public class UpdateSnapshotLifecycleStatsTask
extends ClusterStateUpdateTask {
    private static final Logger logger = LogManager.getLogger(SnapshotRetentionTask.class);
    private final SnapshotLifecycleStats runStats;
    static final String TASK_SOURCE = "update_slm_stats";

    UpdateSnapshotLifecycleStatsTask(SnapshotLifecycleStats runStats) {
        this.runStats = runStats;
    }

    public ClusterState execute(ClusterState currentState) {
        Metadata currentMeta = currentState.metadata();
        ProjectMetadata project = currentMeta.getProject();
        SnapshotLifecycleMetadata currentSlmMeta = (SnapshotLifecycleMetadata)project.custom("snapshot_lifecycle");
        if (currentSlmMeta == null) {
            return currentState;
        }
        SnapshotLifecycleStats newMetrics = currentSlmMeta.getStats().merge(this.runStats);
        SnapshotLifecycleMetadata newSlmMeta = new SnapshotLifecycleMetadata(currentSlmMeta.getSnapshotConfigurations(), LifecycleOperationMetadata.currentSLMMode((ClusterState)currentState), newMetrics);
        return currentState.copyAndUpdateProject(project.id(), builder -> builder.putCustom("snapshot_lifecycle", (Metadata.ProjectCustom)newSlmMeta));
    }

    public void onFailure(Exception e) {
        logger.error(() -> Strings.format((String)"failed to update cluster state with snapshot lifecycle stats, source: [update_slm_stats], missing stats: [%s]", (Object[])new Object[]{this.runStats}), (Throwable)e);
    }
}

