/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.action;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.idp.saml.support.SamlAuthenticationState;
import org.elasticsearch.xpack.idp.saml.support.SamlInitiateSingleSignOnAttributes;

public class SamlInitiateSingleSignOnRequest
extends LegacyActionRequest {
    private static final TransportVersion IDP_CUSTOM_SAML_ATTRIBUTES = TransportVersion.fromName((String)"idp_custom_saml_attributes");
    private String spEntityId;
    private String assertionConsumerService;
    private SamlAuthenticationState samlAuthenticationState;
    private SamlInitiateSingleSignOnAttributes attributes;

    public SamlInitiateSingleSignOnRequest(StreamInput in) throws IOException {
        super(in);
        this.spEntityId = in.readString();
        this.assertionConsumerService = in.readString();
        this.samlAuthenticationState = (SamlAuthenticationState)in.readOptionalWriteable(SamlAuthenticationState::new);
        if (in.getTransportVersion().supports(IDP_CUSTOM_SAML_ATTRIBUTES)) {
            this.attributes = (SamlInitiateSingleSignOnAttributes)in.readOptionalWriteable(SamlInitiateSingleSignOnAttributes::new);
        }
    }

    public SamlInitiateSingleSignOnRequest() {
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException attributesValidationException;
        ActionRequestValidationException validationException = null;
        if (Strings.isNullOrEmpty((String)this.spEntityId)) {
            validationException = ValidateActions.addValidationError((String)"entity_id is missing", validationException);
        }
        if (Strings.isNullOrEmpty((String)this.assertionConsumerService)) {
            validationException = ValidateActions.addValidationError((String)"acs is missing", (ActionRequestValidationException)validationException);
        }
        if (this.attributes != null && (attributesValidationException = this.attributes.validate()) != null) {
            for (String error : attributesValidationException.validationErrors()) {
                validationException = ValidateActions.addValidationError((String)error, (ActionRequestValidationException)validationException);
            }
        }
        return validationException;
    }

    public String getSpEntityId() {
        return this.spEntityId;
    }

    public void setSpEntityId(String spEntityId) {
        this.spEntityId = spEntityId;
    }

    public String getAssertionConsumerService() {
        return this.assertionConsumerService;
    }

    public void setAssertionConsumerService(String assertionConsumerService) {
        this.assertionConsumerService = assertionConsumerService;
    }

    public SamlAuthenticationState getSamlAuthenticationState() {
        return this.samlAuthenticationState;
    }

    public void setSamlAuthenticationState(SamlAuthenticationState samlAuthenticationState) {
        this.samlAuthenticationState = samlAuthenticationState;
    }

    public SamlInitiateSingleSignOnAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(SamlInitiateSingleSignOnAttributes attributes) {
        this.attributes = attributes;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.spEntityId);
        out.writeString(this.assertionConsumerService);
        out.writeOptionalWriteable((Writeable)this.samlAuthenticationState);
        if (out.getTransportVersion().supports(IDP_CUSTOM_SAML_ATTRIBUTES)) {
            out.writeOptionalWriteable((Writeable)this.attributes);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{spEntityId='" + this.spEntityId + "', acs='" + this.assertionConsumerService + "', attributes='" + String.valueOf(this.attributes) + "'}";
    }
}

