/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.system_indices.task;

import java.util.Comparator;
import java.util.Map;
import java.util.stream.Stream;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.system_indices.task.SystemDataStreamMigrationInfo;
import org.elasticsearch.system_indices.task.SystemIndexMigrationInfo;

abstract sealed class SystemResourceMigrationInfo
implements Comparable<SystemResourceMigrationInfo>
permits SystemDataStreamMigrationInfo, SystemIndexMigrationInfo {
    private static final Comparator<SystemResourceMigrationInfo> SAME_CLASS_COMPARATOR = Comparator.comparing(SystemResourceMigrationInfo::getFeatureName).thenComparing(SystemResourceMigrationInfo::getCurrentResourceName);
    protected final String featureName;
    protected final String origin;
    protected final SystemIndices.Feature owningFeature;

    SystemResourceMigrationInfo(String featureName, String origin, SystemIndices.Feature owningFeature) {
        this.featureName = featureName;
        this.origin = origin;
        this.owningFeature = owningFeature;
    }

    protected abstract String getCurrentResourceName();

    String getFeatureName() {
        return this.featureName;
    }

    String getOrigin() {
        return this.origin;
    }

    Client createClient(Client baseClient) {
        return new OriginSettingClient(baseClient, this.getOrigin());
    }

    abstract Stream<IndexMetadata> getIndices(ProjectMetadata var1);

    @Override
    public int compareTo(SystemResourceMigrationInfo o) {
        return SAME_CLASS_COMPARATOR.compare(this, o);
    }

    abstract boolean isCurrentIndexClosed();

    void prepareForIndicesMigration(ProjectMetadata project, Client client, ActionListener<Map<String, Object>> listener) {
        this.owningFeature.getPreMigrationFunction().prepareForIndicesMigration(project, client, listener);
    }

    void indicesMigrationComplete(Map<String, Object> metadata, Client client, ActionListener<Boolean> listener) {
        this.owningFeature.getPostMigrationFunction().indicesMigrationComplete(metadata, client, listener);
    }
}

