/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.system_indices.task;

import java.util.Objects;
import java.util.stream.Stream;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.system_indices.task.SystemDataStreamMigrationInfo;
import org.elasticsearch.system_indices.task.SystemIndexMigrationInfo;
import org.elasticsearch.system_indices.task.SystemResourceMigrationInfo;

class SystemResourceMigrationFactory {
    SystemResourceMigrationFactory() {
    }

    static Stream<SystemResourceMigrationInfo> fromFeature(SystemIndices.Feature feature, ProjectMetadata metadata, IndexScopedSettings indexScopedSettings) {
        return Stream.concat(SystemResourceMigrationFactory.getSystemIndicesMigrationInfos(feature, metadata, indexScopedSettings), SystemResourceMigrationFactory.getSystemDataStreamsMigrationInfos(feature, metadata));
    }

    private static Stream<SystemIndexMigrationInfo> getSystemIndicesMigrationInfos(SystemIndices.Feature feature, ProjectMetadata metadata, IndexScopedSettings indexScopedSettings) {
        return feature.getIndexDescriptors().stream().flatMap(descriptor -> descriptor.getMatchingIndices(metadata).stream().map(arg_0 -> ((ProjectMetadata)metadata).index(arg_0)).filter(imd -> {
            assert (imd != null) : "got null IndexMetadata for index in system descriptor [" + descriptor.getIndexPattern() + "] in feature [" + feature.getName() + "]";
            return Objects.nonNull(imd);
        }).map(imd -> SystemIndexMigrationInfo.build(imd, descriptor, feature, indexScopedSettings)));
    }

    private static Stream<SystemDataStreamMigrationInfo> getSystemDataStreamsMigrationInfos(SystemIndices.Feature feature, ProjectMetadata metadata) {
        return feature.getDataStreamDescriptors().stream().map(descriptor -> {
            DataStream dataStream = (DataStream)metadata.dataStreams().get(descriptor.getDataStreamName());
            return dataStream != null ? SystemDataStreamMigrationInfo.build(dataStream, descriptor, feature) : null;
        }).filter(Objects::nonNull);
    }
}

