/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.ToIntFunction;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.expression.SqlTypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BinaryDateTimeDatePartFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DatePartPipe;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DatePartProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeField;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.NonIsoDateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.QuarterProcessor;

public class DatePart
extends BinaryDateTimeDatePartFunction {
    public DatePart(Source source, Expression dateTimePart, Expression timestamp, ZoneId zoneId) {
        super(source, dateTimePart, timestamp, zoneId);
    }

    public DataType dataType() {
        return DataTypes.INTEGER;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution = super.resolveType();
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = SqlTypeResolutions.isDate(this.right(), this.sourceText(), TypeResolutions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    protected BinaryScalarFunction replaceChildren(Expression newDateTimePart, Expression newTimestamp) {
        return new DatePart(this.source(), newDateTimePart, newTimestamp, this.zoneId());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, DatePart::new, (Object)this.left(), (Object)this.right(), (Object)this.zoneId());
    }

    protected String scriptMethodName() {
        return "datePart";
    }

    public Object fold() {
        return DatePartProcessor.process(this.left().fold(), this.right().fold(), this.zoneId());
    }

    @Override
    protected Pipe createPipe(Pipe dateTimePart, Pipe timestamp, ZoneId zoneId) {
        return new DatePartPipe(this.source(), (Expression)this, dateTimePart, timestamp, zoneId);
    }

    @Override
    protected boolean resolveDateTimeField(String dateTimeField) {
        return Part.resolve(dateTimeField) != null;
    }

    @Override
    protected List<String> findSimilarDateTimeFields(String dateTimeField) {
        return Part.findSimilar(dateTimeField);
    }

    @Override
    protected List<String> validDateTimeFieldValues() {
        return Part.VALID_VALUES;
    }

    public static enum Part implements DateTimeField
    {
        YEAR(DateTimeProcessor.DateTimeExtractor.YEAR::extract, "years", "yyyy", "yy"),
        QUARTER(QuarterProcessor::quarter, "quarters", "qq", "q"),
        MONTH(DateTimeProcessor.DateTimeExtractor.MONTH_OF_YEAR::extract, "months", "mm", "m"),
        DAYOFYEAR(DateTimeProcessor.DateTimeExtractor.DAY_OF_YEAR::extract, "dy", "y"),
        DAY(DateTimeProcessor.DateTimeExtractor.DAY_OF_MONTH::extract, "days", "dd", "d"),
        WEEK(NonIsoDateTimeProcessor.NonIsoDateTimeExtractor.WEEK_OF_YEAR::extract, "weeks", "wk", "ww"),
        WEEKDAY(NonIsoDateTimeProcessor.NonIsoDateTimeExtractor.DAY_OF_WEEK::extract, "weekdays", "dw"),
        HOUR(DateTimeProcessor.DateTimeExtractor.HOUR_OF_DAY::extract, "hours", "hh"),
        MINUTE(DateTimeProcessor.DateTimeExtractor.MINUTE_OF_HOUR::extract, "minutes", "mi", "n"),
        SECOND(DateTimeProcessor.DateTimeExtractor.SECOND_OF_MINUTE::extract, "seconds", "ss", "s"),
        MILLISECOND(dt -> dt.get(ChronoField.MILLI_OF_SECOND), "milliseconds", "ms"),
        MICROSECOND(dt -> dt.get(ChronoField.MICRO_OF_SECOND), "microseconds", "mcs"),
        NANOSECOND(ZonedDateTime::getNano, "nanoseconds", "ns"),
        TZOFFSET(dt -> dt.getOffset().getTotalSeconds() / 60, "tz");

        private static final Map<String, Part> NAME_TO_PART;
        private static final List<String> VALID_VALUES;
        private ToIntFunction<ZonedDateTime> extractFunction;
        private Set<String> aliases;

        private Part(ToIntFunction<ZonedDateTime> extractFunction, String ... aliases) {
            this.extractFunction = extractFunction;
            this.aliases = Set.of(aliases);
        }

        @Override
        public Iterable<String> aliases() {
            return this.aliases;
        }

        public static List<String> findSimilar(String match) {
            return DateTimeField.findSimilar(NAME_TO_PART.keySet(), match);
        }

        public static Part resolve(String dateTimePart) {
            return DateTimeField.resolveMatch(NAME_TO_PART, dateTimePart);
        }

        public Integer extract(ZonedDateTime dateTime) {
            return this.extractFunction.applyAsInt(dateTime);
        }

        static {
            NAME_TO_PART = DateTimeField.initializeResolutionMap((DateTimeField[])Part.values());
            VALID_VALUES = DateTimeField.initializeValidValues((DateTimeField[])Part.values());
        }
    }
}

