/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.grouping;

import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.sql.expression.SqlTypeResolutions;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

public class Histogram
extends GroupingFunction {
    private final Literal interval;
    private final ZoneId zoneId;
    public static final String YEAR_INTERVAL = DateHistogramInterval.YEAR.toString();
    public static final String MONTH_INTERVAL = DateHistogramInterval.MONTH.toString();
    public static final String DAY_INTERVAL = DateHistogramInterval.DAY.toString();

    public Histogram(Source source, Expression field, Expression interval, ZoneId zoneId) {
        super(source, field, Collections.singletonList(interval));
        this.interval = Literal.of((Expression)interval);
        this.zoneId = zoneId;
    }

    public Literal interval() {
        return this.interval;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution = SqlTypeResolutions.isNumericOrDate(this.field(), "HISTOGRAM", TypeResolutions.ParamOrdinal.FIRST);
        if (resolution == Expression.TypeResolution.TYPE_RESOLVED) {
            resolution = SqlDataTypes.isDateBased(this.field().dataType()) ? TypeResolutions.isType((Expression)this.interval, SqlDataTypes::isInterval, (String)"(Date) HISTOGRAM", (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"interval"}) : TypeResolutions.isNumeric((Expression)this.interval, (String)"(Numeric) HISTOGRAM", (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
        }
        return resolution;
    }

    public final GroupingFunction replaceChildren(List<Expression> newChildren) {
        return new Histogram(this.source(), newChildren.get(0), newChildren.get(1), this.zoneId);
    }

    public DataType dataType() {
        return this.field().dataType();
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Histogram::new, (Object)this.field(), (Object)this.interval, (Object)this.zoneId);
    }

    public int hashCode() {
        return Objects.hash(this.field(), this.interval, this.zoneId);
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            Histogram other = (Histogram)((Object)obj);
            return Objects.equals(this.interval, other.interval) && Objects.equals(this.zoneId, other.zoneId);
        }
        return false;
    }
}

