/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.indices.InvalidIndexNameException;

public abstract class ConnectorActionRequest
extends LegacyActionRequest {
    public ConnectorActionRequest() {
    }

    public ConnectorActionRequest(StreamInput in) throws IOException {
        super(in);
    }

    public ActionRequestValidationException validateIndexName(String indexName, ActionRequestValidationException validationException) {
        if (indexName != null) {
            try {
                MetadataCreateIndexService.validateIndexOrAliasName((String)indexName, InvalidIndexNameException::new);
            }
            catch (InvalidIndexNameException e) {
                return ValidateActions.addValidationError((String)e.toString(), (ActionRequestValidationException)validationException);
            }
        }
        return validationException;
    }

    public ActionRequestValidationException validateManagedConnectorIndexPrefix(String indexName, ActionRequestValidationException validationException) {
        if (indexName != null && !indexName.startsWith("content-")) {
            return ValidateActions.addValidationError((String)("Index [" + indexName + "] is invalid. Index attached to an Elastic-managed connector must start with the prefix: [content-]"), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }
}

