/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.inference.textembedding;

import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.inference.InferenceOperator;
import org.elasticsearch.xpack.esql.inference.InferenceService;
import org.elasticsearch.xpack.esql.inference.bulk.BulkInferenceRequestIterator;
import org.elasticsearch.xpack.esql.inference.bulk.BulkInferenceRunner;
import org.elasticsearch.xpack.esql.inference.bulk.BulkInferenceRunnerConfig;
import org.elasticsearch.xpack.esql.inference.textembedding.TextEmbeddingOperatorOutputBuilder;
import org.elasticsearch.xpack.esql.inference.textembedding.TextEmbeddingOperatorRequestIterator;

public class TextEmbeddingOperator
extends InferenceOperator {
    private final EvalOperator.ExpressionEvaluator textEvaluator;

    public TextEmbeddingOperator(DriverContext driverContext, BulkInferenceRunner bulkInferenceRunner, String inferenceId, EvalOperator.ExpressionEvaluator textEvaluator, int maxOutstandingPages) {
        super(driverContext, bulkInferenceRunner, inferenceId, maxOutstandingPages);
        this.textEvaluator = textEvaluator;
    }

    protected void doClose() {
        Releasables.close((Releasable)this.textEvaluator);
    }

    public String toString() {
        return "TextEmbeddingOperator[inference_id=[" + this.inferenceId() + "]]";
    }

    @Override
    protected BulkInferenceRequestIterator requests(Page inputPage) {
        return new TextEmbeddingOperatorRequestIterator((BytesRefBlock)this.textEvaluator.eval(inputPage), this.inferenceId());
    }

    @Override
    protected TextEmbeddingOperatorOutputBuilder outputBuilder(Page input) {
        FloatBlock.Builder outputBlockBuilder = this.blockFactory().newFloatBlockBuilder(input.getPositionCount());
        return new TextEmbeddingOperatorOutputBuilder(outputBlockBuilder, input);
    }

    public record Factory(InferenceService inferenceService, String inferenceId, EvalOperator.ExpressionEvaluator.Factory textEvaluatorFactory) implements Operator.OperatorFactory
    {
        public String describe() {
            return "TextEmbeddingOperator[inference_id=[" + this.inferenceId + "]]";
        }

        public Operator get(DriverContext driverContext) {
            return new TextEmbeddingOperator(driverContext, this.inferenceService.bulkInferenceRunner(), this.inferenceId, this.textEvaluatorFactory.get(driverContext), BulkInferenceRunnerConfig.DEFAULT.maxOutstandingBulkRequests());
        }
    }
}

