/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.ScalbConstantIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.ScalbConstantLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.ScalbIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.ScalbLongEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Scalb
extends EsqlScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Scalb", Scalb::new);
    private final Expression d;
    private final Expression scaleFactor;

    @FunctionInfo(returnType={"double"}, description="Returns the result of `d * 2 ^ scaleFactor`,\nSimilar to Java's `scalb` function. Result is rounded as if\nperformed by a single correctly rounded floating-point multiply\nto a member of the double value set.", examples={@Example(file="floats", tag="scalb")}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.GA, version="9.1.0")})
    public Scalb(Source source, @Param(name="d", type={"double", "integer", "long", "unsigned_long"}, description="Numeric expression for the multiplier. If `null`, the function returns `null`.") Expression d, @Param(name="scaleFactor", type={"integer", "long"}, description="Numeric expression for the scale factor. If `null`, the function returns `null`.") Expression scaleFactor) {
        super(source, Arrays.asList(d, scaleFactor));
        this.d = d;
        this.scaleFactor = scaleFactor;
    }

    private Scalb(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.d);
        out.writeNamedWriteable((NamedWriteable)this.scaleFactor);
    }

    public String getWriteableName() {
        return Scalb.ENTRY.name;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isNumeric((Expression)this.d, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return this.scaleFactor == null ? Expression.TypeResolution.TYPE_RESOLVED : TypeResolutions.isType((Expression)this.scaleFactor, dt -> dt.isWholeNumber() && dt != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"whole number except unsigned_long or counter types"});
    }

    public boolean foldable() {
        return this.d.foldable() && this.scaleFactor.foldable();
    }

    static double process(double d, int scaleFactor) {
        return NumericUtils.asFiniteNumber((double)Math.scalb(d, scaleFactor));
    }

    static double process(double d, long scaleFactor) {
        return NumericUtils.asFiniteNumber((double)Math.scalb(d, Math.toIntExact(scaleFactor)));
    }

    static double processConstantInt(double d, int scaleFactor) {
        return NumericUtils.asFiniteNumber((double)Math.scalb(d, scaleFactor));
    }

    static double processConstantLong(double d, long scaleFactor) {
        return NumericUtils.asFiniteNumber((double)Math.scalb(d, Math.toIntExact(scaleFactor)));
    }

    public final Expression replaceChildren(List<Expression> newChildren) {
        return new Scalb(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Scalb::new, (Object)this.d(), (Object)this.scaleFactor());
    }

    public Expression d() {
        return this.d;
    }

    public Expression scaleFactor() {
        return this.scaleFactor;
    }

    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory dEval = Cast.cast(this.source(), this.d.dataType(), DataType.DOUBLE, toEvaluator.apply(this.d));
        if (this.scaleFactor.foldable()) {
            return switch (this.scaleFactor.dataType()) {
                case DataType.INTEGER -> new ScalbConstantIntEvaluator.Factory(this.source(), dEval, (Integer)this.scaleFactor.fold(toEvaluator.foldCtx()));
                case DataType.LONG -> new ScalbConstantLongEvaluator.Factory(this.source(), dEval, (Long)this.scaleFactor.fold(toEvaluator.foldCtx()));
                default -> throw new IllegalStateException("Invalid type for scaleFactor, should be int or long.");
            };
        }
        EvalOperator.ExpressionEvaluator.Factory scaleFactorEval = toEvaluator.apply(this.scaleFactor);
        DataType dataType = this.scaleFactor.dataType();
        Objects.requireNonNull(dataType);
        DataType dataType2 = dataType;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"INTEGER", "LONG", DataType.class}, (DataType)dataType2, n)) {
            case 0 -> new ScalbIntEvaluator.Factory(this.source(), dEval, scaleFactorEval);
            case 1 -> new ScalbLongEvaluator.Factory(this.source(), dEval, scaleFactorEval);
            default -> {
                DataType type = dataType2;
                throw new IllegalStateException(Strings.format((String)"Invalid type for scaleFactor: %s, should be int or long.", (Object[])new Object[]{type}));
            }
        };
    }
}

