/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Log10DoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Log10IntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Log10LongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Log10UnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class Log10
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Log10", Log10::new);

    @FunctionInfo(returnType={"double"}, description="Returns the logarithm of a value to base 10. The input can be any numeric value, the return value is always a double.\n\nLogs of 0 and negative numbers return `null` as well as a warning.", examples={@Example(file="math", tag="log10")})
    public Log10(Source source, @Param(name="number", type={"double", "integer", "long", "unsigned_long"}, description="Numeric expression. If `null`, the function returns `null`.") Expression n) {
        super(source, n);
    }

    private Log10(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Log10.ENTRY.name;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory field = toEvaluator.apply(this.field());
        DataType fieldType = this.field().dataType();
        if (fieldType == DataType.DOUBLE) {
            return new Log10DoubleEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataType.INTEGER) {
            return new Log10IntEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataType.LONG) {
            return new Log10LongEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataType.UNSIGNED_LONG) {
            return new Log10UnsignedLongEvaluator.Factory(this.source(), field);
        }
        throw EsqlIllegalArgumentException.illegalDataType(fieldType);
    }

    static double process(double val) {
        if (val <= 0.0) {
            throw new ArithmeticException("Log of non-positive number");
        }
        return Math.log10(val);
    }

    static double process(long val) {
        if (val <= 0L) {
            throw new ArithmeticException("Log of non-positive number");
        }
        return Math.log10(val);
    }

    static double processUnsignedLong(long val) {
        if (val == NumericUtils.ZERO_AS_UNSIGNED_LONG) {
            throw new ArithmeticException("Log of non-positive number");
        }
        return Math.log10(EsqlDataTypeConverter.unsignedLongToDouble(val));
    }

    static double process(int val) {
        if (val <= 0) {
            throw new ArithmeticException("Log of non-positive number");
        }
        return Math.log10(val);
    }

    public final Expression replaceChildren(List<Expression> newChildren) {
        return new Log10(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Log10::new, (Object)this.field());
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isNumeric((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }
}

