/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;

public abstract class TimeSeriesAggregateFunction
extends AggregateFunction {
    protected TimeSeriesAggregateFunction(Source source, Expression field, Expression filter, List<? extends Expression> parameters) {
        super(source, field, filter, parameters);
    }

    protected TimeSeriesAggregateFunction(StreamInput in) throws IOException {
        super(in);
    }

    public abstract AggregateFunction perTimeSeriesAggregation();

    public boolean requiredTimeSeriesSource() {
        return false;
    }

    @Override
    public AttributeSet aggregateInputReferences(Supplier<List<Attribute>> inputAttributes) {
        if (this.requiredTimeSeriesSource()) {
            List<? extends Expression> parameters = this.parameters();
            ArrayList<Object> expressions = new ArrayList<Object>(1 + parameters.size() + EsQueryExec.TIME_SERIES_SOURCE_FIELDS.size());
            expressions.add(this.field());
            expressions.addAll(parameters);
            block0: for (Attribute attr : inputAttributes.get()) {
                for (EsField f : EsQueryExec.TIME_SERIES_SOURCE_FIELDS) {
                    if (!attr.name().equals(f.getName())) continue;
                    expressions.add(attr);
                    continue block0;
                }
            }
            return Expressions.references(expressions);
        }
        return super.aggregateInputReferences(inputAttributes);
    }
}

