/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.SourceOperator;

public class LocalSourceOperator
extends SourceOperator {
    protected final PageSupplier supplier;
    boolean finished;

    public LocalSourceOperator(BlockFactory blockFactory, ObjectSupplier objectSupplier) {
        this(() -> BlockUtils.fromListRow(blockFactory, (List)objectSupplier.get()));
    }

    public LocalSourceOperator(BlockFactory blockFactory, ListSupplier listSupplier) {
        this(() -> BlockUtils.fromList(blockFactory, (List)listSupplier.get()));
    }

    public LocalSourceOperator(BlockSupplier blockSupplier) {
        this(() -> {
            Object[] blocks = (Block[])blockSupplier.get();
            return CollectionUtils.isEmpty((Object[])blocks) ? new Page(0, (Block[])blocks) : new Page((Block[])blocks);
        });
    }

    public LocalSourceOperator(PageSupplier pageSupplier) {
        this.supplier = pageSupplier;
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public Page getOutput() {
        Page page = (Page)this.supplier.get();
        this.finished = true;
        return page;
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "LocalSourceOperator";
    }

    public static interface ObjectSupplier
    extends Supplier<List<Object>> {
    }

    public static interface BlockSupplier
    extends Supplier<Block[]> {
    }

    public static interface ListSupplier
    extends Supplier<List<List<Object>>> {
    }

    public static interface PageSupplier
    extends Supplier<Page> {
    }

    public record LocalSourceFactory(Supplier<LocalSourceOperator> factory) implements SourceOperator.SourceOperatorFactory
    {
        @Override
        public SourceOperator get(DriverContext driverContext) {
            return this.factory().get();
        }

        @Override
        public String describe() {
            return "LocalSourceOperator[" + String.valueOf(this.factory) + "]";
        }
    }
}

