/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefArrayVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVectorBuilder;
import org.elasticsearch.compute.data.ConstantBytesRefVector;
import org.elasticsearch.compute.data.ConstantNullVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.OrdinalBytesRefVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.core.ReleasableIterator;

public sealed interface BytesRefVector
extends Vector
permits ConstantBytesRefVector, BytesRefArrayVector, ConstantNullVector, OrdinalBytesRefVector {
    public BytesRef getBytesRef(int var1, BytesRef var2);

    @Override
    public BytesRefBlock asBlock();

    public OrdinalBytesRefVector asOrdinals();

    @Override
    public BytesRefVector filter(int ... var1);

    @Override
    public BytesRefBlock keepMask(BooleanVector var1);

    @Override
    default public BytesRefVector deepCopy(BlockFactory blockFactory) {
        try (BytesRefBlock.Builder builder = blockFactory.newBytesRefBlockBuilder(this.getPositionCount());){
            builder.copyFrom(this.asBlock(), 0, this.getPositionCount());
            builder.mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
            BytesRefVector bytesRefVector = builder.build().asVector();
            return bytesRefVector;
        }
    }

    public ReleasableIterator<? extends BytesRefBlock> lookup(IntBlock var1, ByteSizeValue var2);

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(BytesRefVector vector1, BytesRefVector vector2) {
        int positions = vector1.getPositionCount();
        if (positions != vector2.getPositionCount()) {
            return false;
        }
        for (int pos = 0; pos < positions; ++pos) {
            if (vector1.getBytesRef(pos, new BytesRef()).equals((Object)vector2.getBytesRef(pos, new BytesRef()))) continue;
            return false;
        }
        return true;
    }

    public static int hash(BytesRefVector vector) {
        int len = vector.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < len; ++pos) {
            result = 31 * result + vector.getBytesRef(pos, new BytesRef()).hashCode();
        }
        return result;
    }

    public static BytesRefVector readFrom(BlockFactory blockFactory, StreamInput in) throws IOException {
        int positions = in.readVInt();
        byte serializationType = in.readByte();
        return switch (serializationType) {
            case 0 -> BytesRefVector.readValues(positions, in, blockFactory);
            case 1 -> blockFactory.newConstantBytesRefVector(in.readBytesRef(), positions);
            case 2 -> BytesRefArrayVector.readArrayVector(positions, in, blockFactory);
            case 4 -> OrdinalBytesRefVector.readOrdinalVector(blockFactory, in);
            default -> {
                if (!1.$assertionsDisabled) {
                    throw new AssertionError((Object)("invalid vector serialization type [" + serializationType + "]"));
                }
                throw new IllegalStateException("invalid vector serialization type [" + serializationType + "]");
            }
        };
    }

    default public void writeTo(StreamOutput out) throws IOException {
        int positions = this.getPositionCount();
        TransportVersion version = out.getTransportVersion();
        out.writeVInt(positions);
        if (this.isConstant() && positions > 0) {
            out.writeByte((byte)1);
            out.writeBytesRef(this.getBytesRef(0, new BytesRef()));
        } else {
            BytesRefVector bytesRefVector = this;
            if (bytesRefVector instanceof BytesRefArrayVector) {
                BytesRefArrayVector v = (BytesRefArrayVector)bytesRefVector;
                out.writeByte((byte)2);
                v.writeArrayVector(positions, out);
            } else {
                OrdinalBytesRefVector v;
                bytesRefVector = this;
                if (bytesRefVector instanceof OrdinalBytesRefVector && (v = (OrdinalBytesRefVector)bytesRefVector).isDense()) {
                    out.writeByte((byte)4);
                    v.writeOrdinalVector(out);
                } else {
                    out.writeByte((byte)0);
                    BytesRefVector.writeValues(this, positions, out);
                }
            }
        }
    }

    private static BytesRefVector readValues(int positions, StreamInput in, BlockFactory blockFactory) throws IOException {
        try (Builder builder = blockFactory.newBytesRefVectorBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                builder.appendBytesRef(in.readBytesRef());
            }
            BytesRefVector bytesRefVector = builder.build();
            return bytesRefVector;
        }
    }

    private static void writeValues(BytesRefVector v, int positions, StreamOutput out) throws IOException {
        BytesRef scratch = new BytesRef();
        for (int i = 0; i < positions; ++i) {
            out.writeBytesRef(v.getBytesRef(i, scratch));
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static sealed interface Builder
    extends Vector.Builder
    permits BytesRefVectorBuilder {
        public Builder appendBytesRef(BytesRef var1);

        @Override
        public BytesRefVector build();
    }
}

