/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.concurrent;

import java.util.function.IntSupplier;
import org.ojalgo.OjAlgoUtils;
import org.ojalgo.function.special.PowerOf2;

@FunctionalInterface
public interface ParallelismSupplier
extends IntSupplier {
    default public ParallelismSupplier adjustDown() {
        return () -> PowerOf2.adjustDown(this.getAsInt());
    }

    default public ParallelismSupplier adjustUp() {
        return () -> PowerOf2.adjustUp(this.getAsInt());
    }

    default public ParallelismSupplier average(IntSupplier other) {
        return () -> (this.getAsInt() + other.getAsInt()) / 2;
    }

    default public ParallelismSupplier decrement() {
        return () -> Math.max(1, this.getAsInt() - 1);
    }

    default public ParallelismSupplier divideBy(int divisor) {
        if (divisor > 1) {
            return () -> Math.max(1, (this.getAsInt() + divisor - 1) / divisor);
        }
        return this::getAsInt;
    }

    default public ParallelismSupplier halve() {
        return this.divideBy(2);
    }

    default public ParallelismSupplier increment() {
        return () -> Math.max(1, this.getAsInt() + 1);
    }

    default public ParallelismSupplier max(int other) {
        return this.max(() -> other);
    }

    default public ParallelismSupplier max(IntSupplier other) {
        return () -> Math.max(this.getAsInt(), other.getAsInt());
    }

    default public ParallelismSupplier min(int other) {
        return this.min(() -> other);
    }

    default public ParallelismSupplier min(IntSupplier other) {
        return () -> Math.min(this.getAsInt(), other.getAsInt());
    }

    default public ParallelismSupplier reserveBytes(long bytesPerThread) {
        return () -> Math.max(1, Math.min(this.getAsInt(), PowerOf2.adjustDown(OjAlgoUtils.ENVIRONMENT.memory / bytesPerThread)));
    }

    default public ParallelismSupplier reserveGigaBytes(long gigaBytesPerThread) {
        return this.reserveMegaBytes(1024L * gigaBytesPerThread);
    }

    default public ParallelismSupplier reserveKiloBytes(long kiloBytesPerThread) {
        return this.reserveBytes(1024L * kiloBytesPerThread);
    }

    default public ParallelismSupplier reserveMegaBytes(long megaBytesPerThread) {
        return this.reserveKiloBytes(1024L * megaBytesPerThread);
    }

    default public ParallelismSupplier reserveTeraBytes(long teraBytesPerThread) {
        return this.reserveGigaBytes(1024L * teraBytesPerThread);
    }
}

