/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.jinaai;

import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.jinaai.JinaAIRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.jinaai.action.JinaAIActionVisitor;
import org.elasticsearch.xpack.inference.services.settings.ApiKeySecrets;

public abstract class JinaAIModel
extends Model {
    private final SecureString apiKey;
    private final JinaAIRateLimitServiceSettings rateLimitServiceSettings;

    public JinaAIModel(ModelConfigurations configurations, ModelSecrets secrets, @Nullable ApiKeySecrets apiKeySecrets, JinaAIRateLimitServiceSettings rateLimitServiceSettings) {
        super(configurations, secrets);
        this.rateLimitServiceSettings = Objects.requireNonNull(rateLimitServiceSettings);
        this.apiKey = ServiceUtils.apiKey(apiKeySecrets);
    }

    protected JinaAIModel(JinaAIModel model, TaskSettings taskSettings) {
        super((Model)model, taskSettings);
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
        this.apiKey = model.apiKey();
    }

    protected JinaAIModel(JinaAIModel model, ServiceSettings serviceSettings) {
        super((Model)model, serviceSettings);
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
        this.apiKey = model.apiKey();
    }

    public SecureString apiKey() {
        return this.apiKey;
    }

    public JinaAIRateLimitServiceSettings rateLimitServiceSettings() {
        return this.rateLimitServiceSettings;
    }

    public abstract ExecutableAction accept(JinaAIActionVisitor var1, Map<String, Object> var2);

    public abstract URI uri();
}

