/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.completion;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiModel;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiSecretSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.action.GoogleVertexAiActionVisitor;
import org.elasticsearch.xpack.inference.services.googlevertexai.completion.GoogleVertexAiChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.completion.GoogleVertexAiChatCompletionTaskSettings;

public class GoogleVertexAiChatCompletionModel
extends GoogleVertexAiModel {
    private final URI streamingURI;

    public GoogleVertexAiChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, GoogleVertexAiChatCompletionServiceSettings.fromMap(serviceSettings, context), GoogleVertexAiChatCompletionTaskSettings.fromMap(taskSettings), GoogleVertexAiSecretSettings.fromMap(secrets));
    }

    GoogleVertexAiChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, GoogleVertexAiChatCompletionServiceSettings serviceSettings, GoogleVertexAiChatCompletionTaskSettings taskSettings, @Nullable GoogleVertexAiSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)secrets), serviceSettings);
        try {
            URI uri = serviceSettings.uri();
            URI streamingUri = serviceSettings.streamingUri();
            if (uri != null || streamingUri != null) {
                this.nonStreamingUri = Objects.requireNonNullElse(uri, streamingUri);
                this.streamingURI = Objects.requireNonNullElse(streamingUri, uri);
            } else {
                String location = serviceSettings.location();
                String projectId = serviceSettings.projectId();
                String model = serviceSettings.modelId();
                this.streamingURI = GoogleVertexAiChatCompletionModel.buildUriStreaming(location, projectId, model);
                this.nonStreamingUri = GoogleVertexAiChatCompletionModel.buildUriNonStreaming(location, projectId, model);
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private GoogleVertexAiChatCompletionModel(GoogleVertexAiChatCompletionModel model, GoogleVertexAiChatCompletionTaskSettings taskSettings) {
        super((GoogleVertexAiModel)model, (TaskSettings)taskSettings);
        this.streamingURI = model.streamingURI();
    }

    public static GoogleVertexAiChatCompletionModel of(GoogleVertexAiChatCompletionModel model, UnifiedCompletionRequest request) {
        GoogleVertexAiChatCompletionServiceSettings originalModelServiceSettings = model.getServiceSettings();
        GoogleVertexAiChatCompletionServiceSettings newServiceSettings = new GoogleVertexAiChatCompletionServiceSettings(originalModelServiceSettings.projectId(), originalModelServiceSettings.location(), request.model() != null ? request.model() : originalModelServiceSettings.modelId(), originalModelServiceSettings.uri(), originalModelServiceSettings.streamingUri(), originalModelServiceSettings.provider(), originalModelServiceSettings.rateLimitSettings());
        return new GoogleVertexAiChatCompletionModel(model.getInferenceEntityId(), model.getTaskType(), model.getConfigurations().getService(), newServiceSettings, model.getTaskSettings(), model.getSecretSettings());
    }

    public static GoogleVertexAiChatCompletionModel of(GoogleVertexAiChatCompletionModel model, Map<String, Object> taskSettingsMap) {
        if (taskSettingsMap == null || taskSettingsMap.isEmpty()) {
            return model;
        }
        GoogleVertexAiChatCompletionTaskSettings newTaskSettings = GoogleVertexAiChatCompletionTaskSettings.fromMap(taskSettingsMap);
        if (newTaskSettings.isEmpty() || model.getTaskSettings().equals(newTaskSettings)) {
            return model;
        }
        GoogleVertexAiChatCompletionTaskSettings combinedTaskSettings = GoogleVertexAiChatCompletionTaskSettings.of(model.getTaskSettings(), newTaskSettings);
        return new GoogleVertexAiChatCompletionModel(model, combinedTaskSettings);
    }

    @Override
    public ExecutableAction accept(GoogleVertexAiActionVisitor visitor, Map<String, Object> taskSettings) {
        return visitor.create(this, taskSettings);
    }

    @Override
    public GoogleVertexAiRateLimitServiceSettings rateLimitServiceSettings() {
        return super.rateLimitServiceSettings();
    }

    public GoogleVertexAiChatCompletionServiceSettings getServiceSettings() {
        return (GoogleVertexAiChatCompletionServiceSettings)super.getServiceSettings();
    }

    public GoogleVertexAiChatCompletionTaskSettings getTaskSettings() {
        return (GoogleVertexAiChatCompletionTaskSettings)super.getTaskSettings();
    }

    public GoogleVertexAiSecretSettings getSecretSettings() {
        return (GoogleVertexAiSecretSettings)super.getSecretSettings();
    }

    public URI streamingURI() {
        return this.streamingURI;
    }

    public static URI buildUriNonStreaming(String location, String projectId, String model) throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost(Strings.format((String)"%s%s", (Object[])new Object[]{location, "-aiplatform.googleapis.com"})).setPathSegments(new String[]{"v1", "projects", projectId, "locations", "global", "publishers", "google", "models", Strings.format((String)"%s:%s", (Object[])new Object[]{model, "generateContent"})}).build();
    }

    public static URI buildUriStreaming(String location, String projectId, String model) throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost(Strings.format((String)"%s%s", (Object[])new Object[]{location, "-aiplatform.googleapis.com"})).setPathSegments(new String[]{"v1", "projects", projectId, "locations", "global", "publishers", "google", "models", Strings.format((String)"%s:%s", (Object[])new Object[]{model, "streamGenerateContent"})}).setCustomQuery("alt=sse").build();
    }

    @Override
    public int rateLimitGroupingHash() {
        String projectId = this.getServiceSettings().projectId();
        String location = this.getServiceSettings().location();
        String modelId = this.getServiceSettings().modelId();
        return Objects.hash(projectId, location, modelId, "generateContent", "streamGenerateContent");
    }
}

