/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.IndexOptions;
import org.elasticsearch.index.mapper.vectors.SparseVectorFieldMapper;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class SemanticTextIndexOptions
implements ToXContent {
    private static final String TYPE_FIELD = "type";
    private final SupportedIndexOptions type;
    private final IndexOptions indexOptions;

    public SemanticTextIndexOptions(SupportedIndexOptions type, IndexOptions indexOptions) {
        this.type = type;
        this.indexOptions = indexOptions;
    }

    public SupportedIndexOptions type() {
        return this.type;
    }

    public IndexOptions indexOptions() {
        return this.indexOptions;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SemanticTextIndexOptions otherSemanticTextIndexOptions = (SemanticTextIndexOptions)other;
        return this.type == otherSemanticTextIndexOptions.type && Objects.equals(this.indexOptions, otherSemanticTextIndexOptions.indexOptions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.indexOptions});
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(this.type.value.toLowerCase(Locale.ROOT));
        this.indexOptions.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    private static DenseVectorFieldMapper.DenseVectorIndexOptions parseDenseVectorIndexOptionsFromMap(String fieldName, Map<String, Object> map, IndexVersion indexVersion) {
        try {
            Object type = map.remove(TYPE_FIELD);
            if (type == null) {
                throw new IllegalArgumentException("Required type");
            }
            DenseVectorFieldMapper.VectorIndexType vectorIndexType = (DenseVectorFieldMapper.VectorIndexType)DenseVectorFieldMapper.VectorIndexType.fromString((String)XContentMapValues.nodeStringValue((Object)type, null)).orElseThrow(() -> new IllegalArgumentException("Unsupported index options type " + String.valueOf(type)));
            return vectorIndexType.parseIndexOptions(fieldName, map, indexVersion);
        }
        catch (Exception exc) {
            throw new ElasticsearchException((Throwable)exc);
        }
    }

    private static SparseVectorFieldMapper.SparseVectorIndexOptions parseSparseVectorIndexOptionsFromMap(Map<String, Object> map) {
        try {
            return SparseVectorFieldMapper.SparseVectorIndexOptions.parseFromMap(map);
        }
        catch (Exception exc) {
            throw new ElasticsearchException((Throwable)exc);
        }
    }

    public static enum SupportedIndexOptions {
        DENSE_VECTOR("dense_vector"){

            @Override
            public IndexOptions parseIndexOptions(String fieldName, Map<String, Object> map, IndexVersion indexVersion) {
                return SemanticTextIndexOptions.parseDenseVectorIndexOptionsFromMap(fieldName, map, indexVersion);
            }
        }
        ,
        SPARSE_VECTOR("sparse_vector"){

            @Override
            public IndexOptions parseIndexOptions(String fieldName, Map<String, Object> map, IndexVersion indexVersion) {
                return SemanticTextIndexOptions.parseSparseVectorIndexOptionsFromMap(map);
            }
        };

        public final String value;

        private SupportedIndexOptions(String value) {
            this.value = value;
        }

        public abstract IndexOptions parseIndexOptions(String var1, Map<String, Object> var2, IndexVersion var3);

        public static SupportedIndexOptions fromValue(String value) {
            return Arrays.stream(SupportedIndexOptions.values()).filter(option -> option.value.equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown index options type [" + value + "]"));
        }
    }
}

