/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.mapper;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.InferenceMetadataFieldsMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.inference.mapper.SemanticTextField;
import org.elasticsearch.xpack.inference.mapper.SemanticTextFieldMapper;

public class SemanticInferenceMetadataFieldsMapper
extends InferenceMetadataFieldsMapper {
    private static final SemanticInferenceMetadataFieldsMapper INSTANCE = new SemanticInferenceMetadataFieldsMapper();
    public static final NodeFeature EXPLICIT_NULL_FIXES = new NodeFeature("semantic_text.inference_metadata_fields.explicit_null_fixes");
    public static final NodeFeature INFERENCE_METADATA_FIELDS_ENABLED_BY_DEFAULT = new NodeFeature("semantic_text.inference_metadata_fields.enabled_by_default");
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> InferenceMetadataFieldsMapper.isEnabled((Settings)c.getSettings()) ? INSTANCE : null);

    private SemanticInferenceMetadataFieldsMapper() {
        super((MappedFieldType)FieldType.INSTANCE);
    }

    protected String contentType() {
        return "_inference_fields";
    }

    protected boolean supportsParsingObject() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        boolean isWithinLeaf = context.path().isWithinLeafObject();
        try {
            context.path().setWithinLeafObject(true);
            XContentParser parser = context.parser();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                String fieldName = parser.currentName();
                String[] fieldNameParts = fieldName.split("\\.");
                SemanticInferenceMetadataFieldsMapper.setPath(context.path(), fieldNameParts);
                Mapper mapper = context.mappingLookup().getMapper(fieldName);
                if (mapper instanceof SemanticTextFieldMapper) {
                    SemanticTextFieldMapper fieldMapper = (SemanticTextFieldMapper)mapper;
                    XContentLocation xContentLocation = context.parser().getTokenLocation();
                    SemanticTextField input = fieldMapper.parseSemanticTextField(context);
                    if (input == null) continue;
                    fieldMapper.parseCreateFieldFromContext(context, input, xContentLocation);
                    continue;
                }
                throw new IllegalArgumentException("Field [" + fieldName + "] is not a [semantic_text] field");
            }
        }
        catch (Throwable throwable) {
            context.path().setWithinLeafObject(isWithinLeaf);
            SemanticInferenceMetadataFieldsMapper.setPath(context.path(), new String[]{"_inference_fields"});
            throw throwable;
        }
        context.path().setWithinLeafObject(isWithinLeaf);
        SemanticInferenceMetadataFieldsMapper.setPath(context.path(), new String[]{"_inference_fields"});
    }

    private static void setPath(ContentPath contentPath, String[] newPath) {
        while (contentPath.length() > 0) {
            contentPath.remove();
        }
        for (String pathPart : newPath) {
            contentPath.add(pathPart);
        }
    }

    static class FieldType
    extends InferenceMetadataFieldsMapper.InferenceMetadataFieldType {
        private static final FieldType INSTANCE = new FieldType();

        FieldType() {
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return this.valueFetcher(context.getMappingLookup(), arg_0 -> ((SearchExecutionContext)context).bitsetFilter(arg_0), context.searcher());
        }

        public ValueFetcher valueFetcher(MappingLookup mappingLookup, Function<Query, BitSetProducer> bitSetCache, IndexSearcher searcher) {
            final HashMap<String, ValueFetcher> fieldFetchers = new HashMap<String, ValueFetcher>();
            for (String inferenceField : mappingLookup.inferenceFields().keySet()) {
                MappedFieldType ft = mappingLookup.getFieldType(inferenceField);
                if (ft instanceof SemanticTextFieldMapper.SemanticTextFieldType) {
                    SemanticTextFieldMapper.SemanticTextFieldType semanticTextFieldType = (SemanticTextFieldMapper.SemanticTextFieldType)ft;
                    fieldFetchers.put(inferenceField, semanticTextFieldType.valueFetcherWithInferenceResults(bitSetCache, searcher, false));
                    continue;
                }
                throw new IllegalArgumentException("Invalid inference field [" + ft.name() + "]. Expected field type [semantic_text] but got [" + ft.typeName() + "]");
            }
            if (fieldFetchers.isEmpty()) {
                return ValueFetcher.EMPTY;
            }
            return new ValueFetcher(){

                public void setNextReader(LeafReaderContext context) {
                    fieldFetchers.values().forEach(f -> f.setNextReader(context));
                }

                public List<Object> fetchValues(Source source, int doc, List<Object> ignoredValues) throws IOException {
                    HashMap result = new HashMap();
                    for (Map.Entry entry : fieldFetchers.entrySet()) {
                        List values = ((ValueFetcher)entry.getValue()).fetchValues(source, doc, ignoredValues);
                        if (values.size() <= 0) continue;
                        assert (values.size() == 1);
                        result.put((String)entry.getKey(), values.get(0));
                    }
                    return result.isEmpty() ? List.of() : List.of(result);
                }

                public StoredFieldsSpec storedFieldsSpec() {
                    return StoredFieldsSpec.NO_REQUIREMENTS;
                }
            };
        }

        public String typeName() {
            return "_inference_fields";
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, "[" + this.name() + "] field which is of type [" + this.typeName() + "], does not support term queries", new Object[0]);
        }
    }
}

