/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb.patterntext;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.CharTokenizer;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;

public final class DelimiterAnalyzer
extends Analyzer {
    static final NamedAnalyzer INSTANCE = new NamedAnalyzer("delimiter", AnalyzerScope.GLOBAL, (Analyzer)new DelimiterAnalyzer());

    private DelimiterAnalyzer() {
    }

    protected Analyzer.TokenStreamComponents createComponents(String s) {
        DelimiterTokenizer tokenizer = new DelimiterTokenizer();
        LowerCaseFilter stream = new LowerCaseFilter((TokenStream)tokenizer);
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenStream stream = in;
        stream = new LowerCaseFilter(stream);
        return stream;
    }

    static final class DelimiterTokenizer
    extends CharTokenizer {
        DelimiterTokenizer() {
            super(TokenStream.DEFAULT_TOKEN_ATTRIBUTE_FACTORY);
        }

        protected boolean isTokenChar(int c) {
            return !Character.isWhitespace(c) && c != 61 && c != 63 && c != 58 && c != 91 && c != 93 && c != 123 && c != 125 && c != 34 && c != 92 && c != 39;
        }
    }
}

