/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.elasticsearch.xpack.core.scheduler.Cron;
import org.elasticsearch.xpack.watcher.trigger.schedule.Schedule;

public abstract class CronnableSchedule
implements Schedule {
    private static final Comparator<Cron> CRON_COMPARATOR = Comparator.comparing(Cron::expression);
    protected final Cron[] crons;
    private ZoneId timeZone;

    CronnableSchedule(String ... expressions) {
        this(CronnableSchedule.crons(expressions));
    }

    private CronnableSchedule(Cron ... crons) {
        assert (crons.length > 0);
        this.crons = crons;
        Arrays.sort(crons, CRON_COMPARATOR);
    }

    protected void setTimeZone(ZoneId timeZone) {
        this.timeZone = timeZone;
        for (Cron cron : this.crons) {
            cron.setTimeZone(timeZone);
        }
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public long nextScheduledTimeAfter(long startTime, long time) {
        assert (time >= startTime);
        return Arrays.stream(this.crons).map(cron -> cron.getNextValidTimeAfter(time)).filter(nextValidTime -> nextValidTime > -1L).sorted().findFirst().orElse(-1L);
    }

    public Cron[] crons() {
        return this.crons;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CronnableSchedule that = (CronnableSchedule)o;
        return Objects.deepEquals(this.crons, that.crons) && Objects.equals(this.timeZone, that.timeZone);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.crons), this.timeZone);
    }

    public String toString() {
        return "CronnableSchedule{crons=" + Arrays.toString(this.crons) + ", timeZone=" + String.valueOf(this.timeZone) + "}";
    }

    static Cron[] crons(String ... expressions) {
        Cron[] crons = new Cron[expressions.length];
        for (int i = 0; i < crons.length; ++i) {
            crons[i] = new Cron(expressions[i]);
        }
        return crons;
    }
}

