/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support.search;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;

public class WatcherSearchTemplateRequest
implements ToXContentObject {
    private final String[] indices;
    private final SearchType searchType;
    private final IndicesOptions indicesOptions;
    private final Script template;
    private final BytesReference searchSource;
    private boolean restTotalHitsAsInt = true;
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(WatcherSearchTemplateRequest.class);
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying empty types array in a watcher search request is deprecated.";
    private static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    private static final ParseField BODY_FIELD = new ParseField("body", new String[0]);
    private static final ParseField SEARCH_TYPE_FIELD = new ParseField("search_type", new String[0]);
    private static final ParseField INDICES_OPTIONS_FIELD = new ParseField("indices_options", new String[0]);
    private static final ParseField TEMPLATE_FIELD = new ParseField("template", new String[0]);
    private static final ParseField REST_TOTAL_HITS_AS_INT_FIELD = new ParseField("rest_total_hits_as_int", new String[0]);
    public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.lenientExpandOpen();

    public WatcherSearchTemplateRequest(String[] indices, SearchType searchType, IndicesOptions indicesOptions, BytesReference searchSource) {
        this.indices = indices;
        this.searchType = searchType;
        this.indicesOptions = indicesOptions;
        this.template = new Script(ScriptType.INLINE, "mustache", searchSource.utf8ToString(), Collections.emptyMap());
        this.searchSource = BytesArray.EMPTY;
    }

    public WatcherSearchTemplateRequest(String[] indices, SearchType searchType, IndicesOptions indicesOptions, Script template) {
        this.indices = indices;
        this.searchType = searchType;
        this.indicesOptions = indicesOptions;
        this.template = template;
        this.searchSource = BytesArray.EMPTY;
    }

    public WatcherSearchTemplateRequest(WatcherSearchTemplateRequest original, BytesReference source) {
        this.indices = original.indices;
        this.searchType = original.searchType;
        this.indicesOptions = original.indicesOptions;
        this.searchSource = source;
        this.template = original.template;
        this.restTotalHitsAsInt = original.restTotalHitsAsInt;
    }

    private WatcherSearchTemplateRequest(String[] indices, SearchType searchType, IndicesOptions indicesOptions, BytesReference searchSource, Script template) {
        this.indices = indices;
        this.searchType = searchType;
        this.indicesOptions = indicesOptions;
        this.template = template;
        this.searchSource = searchSource;
    }

    @Nullable
    public Script getTemplate() {
        return this.template;
    }

    public String[] getIndices() {
        return this.indices;
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public IndicesOptions getIndicesOptions() {
        return this.indicesOptions;
    }

    public boolean isRestTotalHitsAsint() {
        return this.restTotalHitsAsInt;
    }

    public void setRestTotalHitsAsInt(boolean value) {
        this.restTotalHitsAsInt = value;
    }

    public BytesReference getSearchSource() {
        return this.searchSource;
    }

    public Script getOrCreateTemplate() {
        if (this.template != null) {
            return this.template;
        }
        return new Script(ScriptType.INLINE, "mustache", this.searchSource.utf8ToString(), Collections.emptyMap());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.searchType != null) {
            builder.field(SEARCH_TYPE_FIELD.getPreferredName(), this.searchType.toString().toLowerCase(Locale.ENGLISH));
        }
        if (this.indices != null) {
            builder.array(INDICES_FIELD.getPreferredName(), this.indices);
        }
        builder.field(REST_TOTAL_HITS_AS_INT_FIELD.getPreferredName(), this.restTotalHitsAsInt);
        if (this.searchSource != null && this.searchSource.length() > 0) {
            try (StreamInput stream = this.searchSource.streamInput();){
                builder.rawField(BODY_FIELD.getPreferredName(), (InputStream)stream);
            }
        }
        if (!this.indicesOptions.equals((Object)DEFAULT_INDICES_OPTIONS)) {
            builder.startObject(INDICES_OPTIONS_FIELD.getPreferredName());
            this.indicesOptions.toXContent(builder, params);
            builder.endObject();
        }
        if (this.template != null) {
            builder.field(TEMPLATE_FIELD.getPreferredName(), (ToXContent)this.template);
        }
        return builder.endObject();
    }

    public static WatcherSearchTemplateRequest fromXContent(XContentParser parser, SearchType searchType) throws IOException {
        XContentParser.Token token;
        ArrayList<String> indices = new ArrayList<String>();
        IndicesOptions indicesOptions = DEFAULT_INDICES_OPTIONS;
        BytesArray searchSource = null;
        Script template = null;
        boolean totalHitsAsInt = true;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (INDICES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            indices.add(parser.textOrNull());
                            continue;
                        }
                        throw new ElasticsearchParseException("could not read search request. expected string values in [" + currentFieldName + "] field, but instead found [" + String.valueOf(token) + "]", new Object[0]);
                    }
                    continue;
                }
                throw new ElasticsearchParseException("could not read search request. unexpected array field [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (BODY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    XContentBuilder builder = XContentFactory.jsonBuilder();
                    try {
                        builder.copyCurrentStructure(parser);
                        searchSource = BytesReference.bytes((XContentBuilder)builder);
                        continue;
                    }
                    finally {
                        if (builder != null) {
                            builder.close();
                        }
                        continue;
                    }
                }
                if (INDICES_OPTIONS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    indicesOptions = IndicesOptions.fromXContent((XContentParser)parser, (IndicesOptions)DEFAULT_INDICES_OPTIONS);
                    continue;
                }
                if (TEMPLATE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    template = Script.parse((XContentParser)parser, (String)"mustache");
                    continue;
                }
                throw new ElasticsearchParseException("could not read search request. unexpected object field [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (INDICES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    String indicesStr = parser.text();
                    indices.addAll(Arrays.asList(Strings.delimitedListToStringArray((String)indicesStr, (String)",", (String)" \t")));
                    continue;
                }
                if (SEARCH_TYPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    searchType = SearchType.fromString((String)parser.text().toLowerCase(Locale.ROOT));
                    continue;
                }
                if (REST_TOTAL_HITS_AS_INT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    totalHitsAsInt = parser.booleanValue();
                    continue;
                }
                throw new ElasticsearchParseException("could not read search request. unexpected string field [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                if (REST_TOTAL_HITS_AS_INT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    totalHitsAsInt = parser.booleanValue();
                    continue;
                }
                throw new ElasticsearchParseException("could not read search request. unexpected boolean field [" + currentFieldName + "]", new Object[0]);
            }
            throw new ElasticsearchParseException("could not read search request. unexpected token [" + String.valueOf(token) + "]", new Object[0]);
        }
        if (searchSource == null) {
            searchSource = BytesArray.EMPTY;
        }
        WatcherSearchTemplateRequest request = new WatcherSearchTemplateRequest(indices.toArray(new String[0]), searchType, indicesOptions, (BytesReference)searchSource, template);
        request.setRestTotalHitsAsInt(totalHitsAsInt);
        return request;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatcherSearchTemplateRequest other = (WatcherSearchTemplateRequest)o;
        return Arrays.equals(this.indices, other.indices) && Objects.equals(this.searchType, other.searchType) && Objects.equals(this.indicesOptions, other.indicesOptions) && Objects.equals(this.searchSource, other.searchSource) && Objects.equals(this.template, other.template) && Objects.equals(this.restTotalHitsAsInt, other.restTotalHitsAsInt);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices), this.searchType, this.indicesOptions, this.searchSource, this.template, this.restTotalHitsAsInt);
    }
}

