/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.multiterms;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceFieldConfig;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.analytics.multiterms.MultiTermsAggregationFactory;
import org.elasticsearch.xpack.analytics.multiterms.MultiTermsAggregator;

public class MultiTermsAggregationBuilder
extends AbstractAggregationBuilder<MultiTermsAggregationBuilder> {
    public static final String NAME = "multi_terms";
    public static final ParseField TERMS_FIELD = new ParseField("terms", new String[0]);
    public static final ParseField ORDER_FIELD = new ParseField("order", new String[0]);
    public static final ParseField SHARD_SIZE_FIELD_NAME = new ParseField("shard_size", new String[0]);
    public static final ParseField MIN_DOC_COUNT_FIELD_NAME = new ParseField("min_doc_count", new String[0]);
    public static final ParseField SHARD_MIN_DOC_COUNT_FIELD_NAME = new ParseField("shard_min_doc_count", new String[0]);
    public static final ParseField REQUIRED_SIZE_FIELD_NAME = new ParseField("size", new String[0]);
    public static final ParseField SHOW_TERM_DOC_COUNT_ERROR = new ParseField("show_term_doc_count_error", new String[0]);
    static final TermsAggregator.ConstantBucketCountThresholds DEFAULT_BUCKET_COUNT_THRESHOLDS = new TermsAggregator.ConstantBucketCountThresholds(1L, 0L, 10, -1);
    public static final ObjectParser<MultiTermsAggregationBuilder, String> PARSER = ObjectParser.fromBuilder((String)"multi_terms", MultiTermsAggregationBuilder::new);
    private List<MultiValuesSourceFieldConfig> terms = Collections.emptyList();
    private BucketOrder order = BucketOrder.compound((BucketOrder[])new BucketOrder[]{BucketOrder.count((boolean)false)});
    boolean showTermDocCountError = false;
    private Aggregator.SubAggCollectionMode collectMode = null;
    private TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(DEFAULT_BUCKET_COUNT_THRESHOLDS);
    static final ValuesSourceRegistry.RegistryKey<MultiTermValuesSupplier> REGISTRY_KEY;

    public static void registerAggregators(ValuesSourceRegistry.Builder registry) {
        registry.registerUsage(NAME);
        registry.register(REGISTRY_KEY, List.of(CoreValuesSourceType.NUMERIC), MultiTermsAggregator::buildNumericTermValues, false);
        registry.register(REGISTRY_KEY, List.of(CoreValuesSourceType.BOOLEAN, CoreValuesSourceType.DATE), MultiTermsAggregator.LongTermValuesSource::new, false);
        registry.register(REGISTRY_KEY, List.of(CoreValuesSourceType.KEYWORD), MultiTermsAggregator.StringTermValuesSource::new, false);
        registry.register(REGISTRY_KEY, List.of(CoreValuesSourceType.IP), MultiTermsAggregator.IPTermValuesSource::new, false);
    }

    public MultiTermsAggregationBuilder(String name) {
        super(name);
    }

    public MultiTermsAggregationBuilder(MultiTermsAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super((AbstractAggregationBuilder)clone, factoriesBuilder, metadata);
        this.terms = new ArrayList<MultiValuesSourceFieldConfig>(clone.terms);
        this.order = clone.order;
        this.collectMode = clone.collectMode;
        this.showTermDocCountError = clone.showTermDocCountError;
        this.bucketCountThresholds = new TermsAggregator.BucketCountThresholds(clone.bucketCountThresholds);
    }

    public MultiTermsAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.terms = in.readCollectionAsList(MultiValuesSourceFieldConfig::new);
        this.order = InternalOrder.Streams.readOrder((StreamInput)in);
        this.collectMode = (Aggregator.SubAggCollectionMode)in.readOptionalWriteable(Aggregator.SubAggCollectionMode::readFromStream);
        this.bucketCountThresholds = new TermsAggregator.BucketCountThresholds(in);
        this.showTermDocCountError = in.readBoolean();
    }

    public boolean supportsSampling() {
        return true;
    }

    public boolean supportsParallelCollection(ToLongFunction<String> fieldCardinalityResolver) {
        for (MultiValuesSourceFieldConfig sourceFieldConfig : this.terms) {
            if (sourceFieldConfig.getScript() != null) {
                return false;
            }
            long cardinality = fieldCardinalityResolver.applyAsLong(sourceFieldConfig.getFieldName());
            if (TermsAggregationBuilder.supportsParallelCollection((long)cardinality, (BucketOrder)this.order, (TermsAggregator.BucketCountThresholds)this.bucketCountThresholds)) continue;
            return false;
        }
        return super.supportsParallelCollection(fieldCardinalityResolver);
    }

    public MultiTermsAggregationBuilder terms(List<MultiValuesSourceFieldConfig> terms) {
        if (terms == null) {
            throw new IllegalArgumentException("[terms] must not be null: [" + this.name + "]");
        }
        if (terms.size() < 2) {
            throw new IllegalArgumentException("The [terms] parameter in the aggregation [" + this.name + "] must be present and have at least 2 fields or scripts." + (terms.size() == 1 ? " For a single field user terms aggregation." : ""));
        }
        this.terms = terms;
        return this;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new MultiTermsAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.MANY;
    }

    protected final void doWriteTo(StreamOutput out) throws IOException {
        out.writeCollection(this.terms);
        this.order.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.collectMode);
        this.bucketCountThresholds.writeTo(out);
        out.writeBoolean(this.showTermDocCountError);
    }

    public MultiTermsAggregationBuilder showTermDocCountError(boolean showTermDocCountError) {
        this.showTermDocCountError = showTermDocCountError;
        return this;
    }

    public MultiTermsAggregationBuilder size(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("[size] must be greater than 0. Found [" + size + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setRequiredSize(size);
        return this;
    }

    public MultiTermsAggregationBuilder shardSize(int shardSize) {
        if (shardSize <= 0) {
            throw new IllegalArgumentException("[shardSize] must be greater than 0. Found [" + shardSize + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setShardSize(shardSize);
        return this;
    }

    public MultiTermsAggregationBuilder minDocCount(long minDocCount) {
        if (minDocCount < 1L) {
            throw new IllegalArgumentException("[minDocCount] must be greater than or equal to 1. Found [" + minDocCount + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setMinDocCount(minDocCount);
        return this;
    }

    public MultiTermsAggregationBuilder shardMinDocCount(long shardMinDocCount) {
        if (shardMinDocCount < 0L) {
            throw new IllegalArgumentException("[shardMinDocCount] must be greater than or equal to 0. Found [" + shardMinDocCount + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setShardMinDocCount(shardMinDocCount);
        return this;
    }

    public MultiTermsAggregationBuilder order(BucketOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null: [" + this.name + "]");
        }
        this.order = order instanceof InternalOrder.CompoundOrder || InternalOrder.isKeyOrder((BucketOrder)order) ? order : BucketOrder.compound((BucketOrder[])new BucketOrder[]{order});
        return this;
    }

    public MultiTermsAggregationBuilder order(List<BucketOrder> orders) {
        if (orders == null) {
            throw new IllegalArgumentException("[orders] must not be null: [" + this.name + "]");
        }
        this.order(orders.size() > 1 ? BucketOrder.compound(orders) : orders.get(0));
        return this;
    }

    public MultiTermsAggregationBuilder collectMode(Aggregator.SubAggCollectionMode collectMode) {
        if (collectMode == null) {
            throw new IllegalArgumentException("[collectMode] must not be null: [" + this.name + "]");
        }
        this.collectMode = collectMode;
        return this;
    }

    protected final MultiTermsAggregationFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        List<ValuesSourceConfig> configs = this.resolveConfig(context);
        return new MultiTermsAggregationFactory(this.name, configs, configs.stream().map(ValuesSourceConfig::format).collect(Collectors.toList()), this.showTermDocCountError, this.order, this.collectMode, this.bucketCountThresholds, context, parent, subFactoriesBuilder, this.metadata);
    }

    protected List<ValuesSourceConfig> resolveConfig(AggregationContext context) {
        ArrayList<ValuesSourceConfig> configs = new ArrayList<ValuesSourceConfig>();
        for (MultiValuesSourceFieldConfig field : this.terms) {
            configs.add(ValuesSourceConfig.resolveUnregistered((AggregationContext)context, (ValueType)field.getUserValueTypeHint(), (String)field.getFieldName(), (Script)field.getScript(), (Object)field.getMissing(), (ZoneId)field.getTimeZone(), (String)field.getFormat(), (ValuesSourceType)CoreValuesSourceType.KEYWORD));
        }
        return configs;
    }

    public final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.bucketCountThresholds.toXContent(builder, params);
        builder.field(SHOW_TERM_DOC_COUNT_ERROR.getPreferredName(), this.showTermDocCountError);
        builder.field(ORDER_FIELD.getPreferredName());
        this.order.toXContent(builder, params);
        if (this.collectMode != null) {
            builder.field(Aggregator.SubAggCollectionMode.KEY.getPreferredName(), this.collectMode.parseField().getPreferredName());
        }
        if (this.terms != null) {
            builder.field(TERMS_FIELD.getPreferredName(), this.terms);
        }
        builder.endObject();
        return builder;
    }

    public String getType() {
        return NAME;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.terms, this.order, this.collectMode, this.bucketCountThresholds);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MultiTermsAggregationBuilder other = (MultiTermsAggregationBuilder)((Object)obj);
        return Objects.equals(this.terms, other.terms) && Objects.equals(this.order, other.order) && Objects.equals(this.collectMode, other.collectMode) && Objects.equals(this.bucketCountThresholds, other.bucketCountThresholds);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }

    private static /* synthetic */ MultiValuesSourceFieldConfig lambda$static$0(ContextParser termsParser, XContentParser p, String n) throws IOException {
        return ((MultiValuesSourceFieldConfig.Builder)termsParser.parse(p, null)).build();
    }

    static {
        ObjectParser termsParser = MultiValuesSourceFieldConfig.parserBuilder((boolean)true, (boolean)true, (boolean)false, (boolean)true, (boolean)false);
        PARSER.declareBoolean(MultiTermsAggregationBuilder::showTermDocCountError, SHOW_TERM_DOC_COUNT_ERROR);
        PARSER.declareObjectArray(MultiTermsAggregationBuilder::terms, (arg_0, arg_1) -> MultiTermsAggregationBuilder.lambda$static$0((ContextParser)termsParser, arg_0, arg_1), TERMS_FIELD);
        PARSER.declareInt(MultiTermsAggregationBuilder::shardSize, SHARD_SIZE_FIELD_NAME);
        PARSER.declareLong(MultiTermsAggregationBuilder::minDocCount, MIN_DOC_COUNT_FIELD_NAME);
        PARSER.declareLong(MultiTermsAggregationBuilder::shardMinDocCount, SHARD_MIN_DOC_COUNT_FIELD_NAME);
        PARSER.declareInt(MultiTermsAggregationBuilder::size, REQUIRED_SIZE_FIELD_NAME);
        PARSER.declareObjectArray(MultiTermsAggregationBuilder::order, (p, c) -> InternalOrder.Parser.parseOrderParam((XContentParser)p), ORDER_FIELD);
        PARSER.declareField(MultiTermsAggregationBuilder::collectMode, (p, c) -> Aggregator.SubAggCollectionMode.parse((String)p.text(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE), Aggregator.SubAggCollectionMode.KEY, ObjectParser.ValueType.STRING);
        REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey(NAME, MultiTermValuesSupplier.class);
    }

    @FunctionalInterface
    static interface MultiTermValuesSupplier {
        public MultiTermsAggregator.TermValuesSource build(ValuesSourceConfig var1);
    }
}

