/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.rest;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.datastreams.UpdateDataStreamMappingsAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestRefCountedChunkedToXContentListener;
import org.elasticsearch.xcontent.XContentParser;

@ServerlessScope(value=Scope.PUBLIC)
public class RestUpdateDataStreamMappingsAction
extends BaseRestHandler {
    public String getName() {
        return "update_data_stream_mappings_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_data_stream/{name}/_mappings"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        CompressedXContent mappings;
        try (XContentParser parser = request.contentParser();){
            parser.nextToken();
            mappings = Template.parseMappings((XContentParser)parser);
        }
        boolean dryRun = request.paramAsBoolean("dry_run", false);
        UpdateDataStreamMappingsAction.Request updateDataStreamMappingsRequest = new UpdateDataStreamMappingsAction.Request(mappings, dryRun, RestUtils.getMasterNodeTimeout((RestRequest)request), RestUtils.getAckTimeout((RestRequest)request)).indices(Strings.splitStringByCommaToArray((String)request.param("name")));
        return channel -> new RestCancellableNodeClient(client, request.getHttpChannel()).execute((ActionType)UpdateDataStreamMappingsAction.INSTANCE, (ActionRequest)updateDataStreamMappingsRequest, (ActionListener)new RestRefCountedChunkedToXContentListener(channel));
    }
}

