/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.action;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.pool.PoolStats;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetInferenceDiagnosticsAction
extends ActionType<Response> {
    public static final GetInferenceDiagnosticsAction INSTANCE = new GetInferenceDiagnosticsAction();
    public static final String NAME = "cluster:monitor/xpack/inference/diagnostics/get";
    private static final TransportVersion ML_INFERENCE_ENDPOINT_CACHE = TransportVersion.fromName((String)"ml_inference_endpoint_cache");
    private static final TransportVersion INFERENCE_API_EIS_DIAGNOSTICS = TransportVersion.fromName((String)"inference_api_eis_diagnostics");

    public GetInferenceDiagnosticsAction() {
        super(NAME);
    }

    public static class NodeResponse
    extends BaseNodeResponse
    implements ToXContentFragment {
        private static final String EXTERNAL_FIELD = "external";
        private static final String EIS_FIELD = "eis_mtls";
        private static final String CONNECTION_POOL_STATS_FIELD_NAME = "connection_pool_stats";
        static final String INFERENCE_ENDPOINT_REGISTRY_STATS_FIELD_NAME = "inference_endpoint_registry";
        private final ConnectionPoolStats externalConnectionPoolStats;
        private final ConnectionPoolStats eisMtlsConnectionPoolStats;
        @Nullable
        private final Stats inferenceEndpointRegistryStats;

        public NodeResponse(DiscoveryNode node, PoolStats poolStats, PoolStats eisPoolStats, @Nullable Stats inferenceEndpointRegistryStats) {
            super(node);
            this.externalConnectionPoolStats = ConnectionPoolStats.of(poolStats);
            this.eisMtlsConnectionPoolStats = ConnectionPoolStats.of(eisPoolStats);
            this.inferenceEndpointRegistryStats = inferenceEndpointRegistryStats;
        }

        public NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.externalConnectionPoolStats = new ConnectionPoolStats(in);
            this.eisMtlsConnectionPoolStats = in.getTransportVersion().supports(INFERENCE_API_EIS_DIAGNOSTICS) ? new ConnectionPoolStats(in) : ConnectionPoolStats.EMPTY;
            this.inferenceEndpointRegistryStats = in.getTransportVersion().supports(ML_INFERENCE_ENDPOINT_CACHE) ? (Stats)in.readOptionalWriteable(Stats::new) : null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.externalConnectionPoolStats.writeTo(out);
            if (out.getTransportVersion().supports(INFERENCE_API_EIS_DIAGNOSTICS)) {
                this.eisMtlsConnectionPoolStats.writeTo(out);
            }
            if (out.getTransportVersion().supports(ML_INFERENCE_ENDPOINT_CACHE)) {
                out.writeOptionalWriteable((Writeable)this.inferenceEndpointRegistryStats);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(EXTERNAL_FIELD);
            builder.field(CONNECTION_POOL_STATS_FIELD_NAME, (ToXContent)this.externalConnectionPoolStats, params);
            builder.endObject();
            builder.startObject(EIS_FIELD);
            builder.field(CONNECTION_POOL_STATS_FIELD_NAME, (ToXContent)this.eisMtlsConnectionPoolStats, params);
            builder.endObject();
            if (this.inferenceEndpointRegistryStats != null) {
                builder.field(INFERENCE_ENDPOINT_REGISTRY_STATS_FIELD_NAME, (ToXContent)this.inferenceEndpointRegistryStats, params);
            }
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            NodeResponse response = (NodeResponse)((Object)o);
            return Objects.equals(this.externalConnectionPoolStats, response.externalConnectionPoolStats) && Objects.equals(this.eisMtlsConnectionPoolStats, response.eisMtlsConnectionPoolStats) && Objects.equals(this.inferenceEndpointRegistryStats, response.inferenceEndpointRegistryStats);
        }

        public int hashCode() {
            return Objects.hash(this.externalConnectionPoolStats, this.eisMtlsConnectionPoolStats, this.inferenceEndpointRegistryStats);
        }

        ConnectionPoolStats getExternalConnectionPoolStats() {
            return this.externalConnectionPoolStats;
        }

        ConnectionPoolStats getEisMtlsConnectionPoolStats() {
            return this.eisMtlsConnectionPoolStats;
        }

        public Stats getInferenceEndpointRegistryStats() {
            return this.inferenceEndpointRegistryStats;
        }

        static class ConnectionPoolStats
        implements ToXContentObject,
        Writeable {
            private static final String LEASED_CONNECTIONS = "leased_connections";
            private static final String PENDING_CONNECTIONS = "pending_connections";
            private static final String AVAILABLE_CONNECTIONS = "available_connections";
            private static final String MAX_CONNECTIONS = "max_connections";
            private static final ConnectionPoolStats EMPTY = new ConnectionPoolStats(0, 0, 0, 0);
            private final int leasedConnections;
            private final int pendingConnections;
            private final int availableConnections;
            private final int maxConnections;

            static ConnectionPoolStats of(PoolStats poolStats) {
                return new ConnectionPoolStats(poolStats.getLeased(), poolStats.getPending(), poolStats.getAvailable(), poolStats.getMax());
            }

            ConnectionPoolStats(int leasedConnections, int pendingConnections, int availableConnections, int maxConnections) {
                this.leasedConnections = leasedConnections;
                this.pendingConnections = pendingConnections;
                this.availableConnections = availableConnections;
                this.maxConnections = maxConnections;
            }

            ConnectionPoolStats(StreamInput in) throws IOException {
                this.leasedConnections = in.readVInt();
                this.pendingConnections = in.readVInt();
                this.availableConnections = in.readVInt();
                this.maxConnections = in.readVInt();
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(LEASED_CONNECTIONS, this.leasedConnections);
                builder.field(PENDING_CONNECTIONS, this.pendingConnections);
                builder.field(AVAILABLE_CONNECTIONS, this.availableConnections);
                builder.field(MAX_CONNECTIONS, this.maxConnections);
                builder.endObject();
                return builder;
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeVInt(this.leasedConnections);
                out.writeVInt(this.pendingConnections);
                out.writeVInt(this.availableConnections);
                out.writeVInt(this.maxConnections);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ConnectionPoolStats that = (ConnectionPoolStats)o;
                return this.leasedConnections == that.leasedConnections && this.pendingConnections == that.pendingConnections && this.availableConnections == that.availableConnections && this.maxConnections == that.maxConnections;
            }

            public int hashCode() {
                return Objects.hash(this.leasedConnections, this.pendingConnections, this.availableConnections, this.maxConnections);
            }

            int getLeasedConnections() {
                return this.leasedConnections;
            }

            int getPendingConnections() {
                return this.pendingConnections;
            }

            int getAvailableConnections() {
                return this.availableConnections;
            }

            int getMaxConnections() {
                return this.maxConnections;
            }
        }

        public record Stats(int entryCount, long hits, long misses, long evictions) implements ToXContentObject,
        Writeable
        {
            private static final String NUM_OF_CACHE_ENTRIES = "cache_count";
            private static final String CACHE_HITS = "cache_hits";
            private static final String CACHE_MISSES = "cache_misses";
            private static final String CACHE_EVICTIONS = "cache_evictions";

            public Stats(StreamInput in) throws IOException {
                this(in.readVInt(), in.readVLong(), in.readVLong(), in.readVLong());
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeVInt(this.entryCount);
                out.writeVLong(this.hits);
                out.writeVLong(this.misses);
                out.writeVLong(this.evictions);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return builder.startObject().field(NUM_OF_CACHE_ENTRIES, this.entryCount).field(CACHE_HITS, this.hits).field(CACHE_MISSES, this.misses).field(CACHE_EVICTIONS, this.evictions).endObject();
            }
        }
    }

    public static class Response
    extends BaseNodesResponse<NodeResponse>
    implements Writeable,
    ToXContentObject {
        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public Response(ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            for (Map.Entry entry : this.getNodesMap().entrySet()) {
                NodeResponse response = (NodeResponse)((Object)entry.getValue());
                builder.startObject((String)entry.getKey());
                response.toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }

        protected List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readCollectionAsList(NodeResponse::new);
        }

        protected void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) throws IOException {
            out.writeCollection(nodes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)((Object)o);
            return Objects.equals(this.getNodes(), that.getNodes()) && Objects.equals(this.failures(), that.failures());
        }

        public int hashCode() {
            return Objects.hash(this.getNodes(), this.failures());
        }
    }

    public static class NodeRequest
    extends AbstractTransportRequest {
        public NodeRequest(StreamInput in) throws IOException {
            super(in);
        }

        public NodeRequest() {
        }
    }

    public static class Request
    extends BaseNodesRequest {
        public Request() {
            super((String[])null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && ((Object)((Object)this)).getClass() == o.getClass();
        }

        public int hashCode() {
            return Objects.hash(GetInferenceDiagnosticsAction.NAME);
        }
    }
}

