/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ingest.PutPipelineRequest;
import org.elasticsearch.action.ingest.PutPipelineTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.enrich.EnrichPolicyRunner;

public class EnrichPolicyReindexPipeline {
    static final String CURRENT_PIPELINE_VERSION_NAME = "7";
    static final int ENRICH_PIPELINE_LAST_UPDATED_VERSION = Version.V_7_4_0.id;

    static String pipelineName() {
        return "enrich-policy-reindex-7";
    }

    static boolean exists(ProjectMetadata project) {
        PipelineConfiguration pipeline;
        IngestMetadata ingestMetadata = (IngestMetadata)project.custom("ingest");
        if (ingestMetadata != null && (pipeline = (PipelineConfiguration)ingestMetadata.getPipelines().get(EnrichPolicyReindexPipeline.pipelineName())) != null) {
            Number number;
            Object version = pipeline.getConfig().get("version");
            return version instanceof Number && (number = (Number)version).intValue() >= ENRICH_PIPELINE_LAST_UPDATED_VERSION;
        }
        return false;
    }

    public static void create(Client client, ActionListener<AcknowledgedResponse> listener) {
        BytesReference pipeline = BytesReference.bytes((XContentBuilder)EnrichPolicyReindexPipeline.currentEnrichPipelineDefinition(XContentType.JSON));
        client.execute(PutPipelineTransportAction.TYPE, (ActionRequest)new PutPipelineRequest(EnrichPolicyRunner.ENRICH_MASTER_REQUEST_TIMEOUT, EnrichPolicyRunner.ENRICH_MASTER_REQUEST_TIMEOUT, EnrichPolicyReindexPipeline.pipelineName(), pipeline, XContentType.JSON), listener);
    }

    private static XContentBuilder currentEnrichPipelineDefinition(XContentType xContentType) {
        try {
            XContentBuilder builder = XContentBuilder.builder((XContent)xContentType.xContent());
            builder.startObject();
            builder.field("description", "This pipeline sanitizes documents that will be stored in enrich indices for ingest lookup purposes. It is an internal pipeline and should not be modified.");
            builder.field("version", ENRICH_PIPELINE_LAST_UPDATED_VERSION);
            builder.startArray("processors");
            builder.startObject();
            builder.startObject("remove");
            builder.field("field", "_id");
            builder.endObject();
            builder.endObject();
            builder.endArray();
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create pipeline for enrich document sanitization", e);
        }
    }
}

