/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.writeloadforecaster;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.function.BooleanSupplier;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadataStats;
import org.elasticsearch.cluster.metadata.IndexWriteLoad;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.routing.allocation.WriteLoadForecaster;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.writeloadforecaster.WriteLoadForecasterPlugin;

class LicensedWriteLoadForecaster
implements WriteLoadForecaster {
    private static final Logger logger = LogManager.getLogger(LicensedWriteLoadForecaster.class);
    public static final Setting<TimeValue> MAX_INDEX_AGE_SETTING = Setting.timeSetting((String)"write_load_forecaster.max_index_age", (TimeValue)TimeValue.timeValueDays((long)7L), (TimeValue)TimeValue.timeValueHours((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private final BooleanSupplier hasValidLicenseSupplier;
    private final ThreadPool threadPool;
    private volatile TimeValue maxIndexAge;
    private volatile boolean hasValidLicense;
    private static final VarHandle VH_HAS_VALID_LICENSE_FIELD;

    LicensedWriteLoadForecaster(BooleanSupplier hasValidLicenseSupplier, ThreadPool threadPool, Settings settings, ClusterSettings clusterSettings) {
        this(hasValidLicenseSupplier, threadPool, (TimeValue)MAX_INDEX_AGE_SETTING.get(settings));
        clusterSettings.addSettingsUpdateConsumer(MAX_INDEX_AGE_SETTING, this::setMaxIndexAgeSetting);
    }

    LicensedWriteLoadForecaster(BooleanSupplier hasValidLicenseSupplier, ThreadPool threadPool, TimeValue maxIndexAge) {
        this.hasValidLicenseSupplier = hasValidLicenseSupplier;
        this.threadPool = threadPool;
        this.maxIndexAge = maxIndexAge;
    }

    private void setMaxIndexAgeSetting(TimeValue updatedMaxIndexAge) {
        this.maxIndexAge = updatedMaxIndexAge;
    }

    public ProjectMetadata.Builder withWriteLoadForecastForWriteIndex(String dataStreamName, ProjectMetadata.Builder metadata) {
        if (!this.hasValidLicense) {
            return metadata;
        }
        DataStream dataStream = metadata.dataStream(dataStreamName);
        if (dataStream == null) {
            return metadata;
        }
        LicensedWriteLoadForecaster.clearPreviousForecast(dataStream, metadata);
        List<IndexWriteLoad> indicesWriteLoadWithinMaxAgeRange = DataStream.getIndicesWithinMaxAgeRange((DataStream)dataStream, arg_0 -> ((ProjectMetadata.Builder)metadata).getSafe(arg_0), (TimeValue)this.maxIndexAge, () -> ((ThreadPool)this.threadPool).absoluteTimeInMillis()).stream().filter(index -> !index.equals((Object)dataStream.getWriteIndex())).map(arg_0 -> ((ProjectMetadata.Builder)metadata).getSafe(arg_0)).map(IndexMetadata::getStats).filter(Objects::nonNull).map(IndexMetadataStats::writeLoad).filter(Objects::nonNull).toList();
        OptionalDouble forecastIndexWriteLoad = LicensedWriteLoadForecaster.forecastIndexWriteLoad(indicesWriteLoadWithinMaxAgeRange);
        if (forecastIndexWriteLoad.isEmpty()) {
            return metadata;
        }
        IndexMetadata writeIndex = metadata.getSafe(dataStream.getWriteIndex());
        metadata.put(IndexMetadata.builder((IndexMetadata)writeIndex).indexWriteLoadForecast(Double.valueOf(forecastIndexWriteLoad.getAsDouble() / (double)writeIndex.getNumberOfShards())).build(), false);
        return metadata;
    }

    private static void clearPreviousForecast(DataStream dataStream, ProjectMetadata.Builder metadata) {
        if (dataStream.getIndices().size() > 1) {
            Index previousWriteIndex = (Index)dataStream.getIndices().get(dataStream.getIndices().size() - 2);
            IndexMetadata previousWriteIndexMetadata = metadata.getSafe(previousWriteIndex);
            IndexMetadata.Builder previousWriteIndexMetadataBuilder = IndexMetadata.builder((IndexMetadata)previousWriteIndexMetadata).indexWriteLoadForecast(null);
            if (previousWriteIndexMetadata.getSettings().hasValue(WriteLoadForecasterPlugin.OVERRIDE_WRITE_LOAD_FORECAST_SETTING.getKey())) {
                Settings.Builder previousWriteIndexSettings = Settings.builder().put(previousWriteIndexMetadata.getSettings());
                previousWriteIndexSettings.remove(WriteLoadForecasterPlugin.OVERRIDE_WRITE_LOAD_FORECAST_SETTING.getKey());
                previousWriteIndexMetadataBuilder.settings(previousWriteIndexSettings);
                previousWriteIndexMetadataBuilder.settingsVersion(previousWriteIndexMetadata.getSettingsVersion() + 1L);
            }
            metadata.put(previousWriteIndexMetadataBuilder.build(), false);
        }
    }

    static OptionalDouble forecastIndexWriteLoad(List<IndexWriteLoad> indicesWriteLoadWithinMaxAgeRange) {
        double allIndicesWriteLoad = 0.0;
        long allIndicesUptime = 0L;
        for (IndexWriteLoad writeLoad : indicesWriteLoadWithinMaxAgeRange) {
            double totalShardWriteLoad = 0.0;
            long totalShardUptimeInMillis = 0L;
            long maxShardUptimeInMillis = 0L;
            for (int shardId = 0; shardId < writeLoad.numberOfShards(); ++shardId) {
                OptionalDouble writeLoadForShard = writeLoad.getWriteLoadForShard(shardId);
                OptionalLong uptimeInMillisForShard = writeLoad.getUptimeInMillisForShard(shardId);
                if (!writeLoadForShard.isPresent()) continue;
                assert (uptimeInMillisForShard.isPresent());
                double shardWriteLoad = writeLoadForShard.getAsDouble();
                long shardUptimeInMillis = uptimeInMillisForShard.getAsLong();
                totalShardWriteLoad += shardWriteLoad * (double)shardUptimeInMillis;
                totalShardUptimeInMillis += shardUptimeInMillis;
                maxShardUptimeInMillis = Math.max(maxShardUptimeInMillis, shardUptimeInMillis);
            }
            double weightedAverageShardWriteLoad = totalShardWriteLoad / (double)totalShardUptimeInMillis;
            double totalIndexWriteLoad = weightedAverageShardWriteLoad * (double)writeLoad.numberOfShards();
            allIndicesWriteLoad += totalIndexWriteLoad * (double)maxShardUptimeInMillis;
            allIndicesUptime += maxShardUptimeInMillis;
        }
        return allIndicesUptime == 0L ? OptionalDouble.empty() : OptionalDouble.of(allIndicesWriteLoad / (double)allIndicesUptime);
    }

    @SuppressForbidden(reason="This is the only place where IndexMetadata#getForecastedWriteLoad is allowed to be used")
    public OptionalDouble getForecastedWriteLoad(IndexMetadata indexMetadata) {
        if (!this.hasValidLicense) {
            return OptionalDouble.empty();
        }
        if (WriteLoadForecasterPlugin.OVERRIDE_WRITE_LOAD_FORECAST_SETTING.exists(indexMetadata.getSettings())) {
            Double overrideWriteLoadForecast = (Double)WriteLoadForecasterPlugin.OVERRIDE_WRITE_LOAD_FORECAST_SETTING.get(indexMetadata.getSettings());
            return OptionalDouble.of(overrideWriteLoadForecast);
        }
        return indexMetadata.getForecastedWriteLoad();
    }

    public void refreshLicense() {
        boolean oldValue;
        boolean newValue = this.hasValidLicenseSupplier.getAsBoolean();
        if (newValue != (oldValue = VH_HAS_VALID_LICENSE_FIELD.getAndSet(this, newValue))) {
            logger.info("license state changed, now [{}]", new Object[]{newValue ? "valid" : "not valid"});
        }
    }

    static {
        try {
            VH_HAS_VALID_LICENSE_FIELD = MethodHandles.lookup().in(LicensedWriteLoadForecaster.class).findVarHandle(LicensedWriteLoadForecaster.class, "hasValidLicense", Boolean.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

