/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.polynomial;

import java.math.BigDecimal;
import org.ojalgo.array.Array1D;
import org.ojalgo.function.BasicFunction;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.function.polynomial.AbstractPolynomial;
import org.ojalgo.function.polynomial.RationalPolynomial;
import org.ojalgo.structure.Access1D;
import org.ojalgo.type.TypeUtils;

public final class BigPolynomial
extends AbstractPolynomial<BigDecimal> {
    public BigPolynomial(int degree) {
        super((Array1D)Array1D.BIG.make(degree + 1));
    }

    BigPolynomial(Array1D<BigDecimal> coefficients) {
        super(coefficients);
    }

    @Override
    public void estimate(Access1D<?> x, Access1D<?> y) {
        RationalPolynomial delegate = new RationalPolynomial(this.degree());
        delegate.estimate(x, y);
        this.set(delegate);
    }

    @Override
    public BigDecimal integrate(BigDecimal fromPoint, BigDecimal toPoint) {
        BasicFunction tmpPrim = this.buildPrimitive();
        BigDecimal tmpFromVal = tmpPrim.invoke(fromPoint);
        BigDecimal tmpToVal = tmpPrim.invoke(toPoint);
        return tmpToVal.subtract(tmpFromVal);
    }

    @Override
    public BigDecimal invoke(BigDecimal arg) {
        int tmpPower = this.degree();
        BigDecimal retVal = (BigDecimal)this.get(tmpPower);
        while (--tmpPower >= 0) {
            retVal = ((BigDecimal)this.get(tmpPower)).add(arg.multiply(retVal));
        }
        return retVal;
    }

    @Override
    public void set(Access1D<?> coefficients) {
        int tmpLimit = Math.min(this.size(), coefficients.size());
        for (int p = 0; p < tmpLimit; ++p) {
            this.set(p, TypeUtils.toBigDecimal(coefficients.get(p)));
        }
    }

    @Override
    protected BigDecimal getDerivativeFactor(int power) {
        int tmpNextIndex = power + 1;
        return ((BigDecimal)this.get(tmpNextIndex)).multiply(new BigDecimal(tmpNextIndex));
    }

    @Override
    protected BigDecimal getPrimitiveFactor(int power) {
        if (power <= 0) {
            return BigMath.ZERO;
        }
        return ((BigDecimal)this.get(power - 1)).divide(new BigDecimal(power));
    }

    @Override
    protected AbstractPolynomial<BigDecimal> makeInstance(int size) {
        return new BigPolynomial((Array1D)Array1D.BIG.make(size));
    }
}

