/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action.repositories;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.action.repositories.DeleteInternalCcrRepositoryRequest;

public class DeleteInternalCcrRepositoryAction
extends ActionType<ActionResponse.Empty> {
    public static final DeleteInternalCcrRepositoryAction INSTANCE = new DeleteInternalCcrRepositoryAction();
    public static final String NAME = "internal:admin/ccr/internal_repository/delete";

    private DeleteInternalCcrRepositoryAction() {
        super(NAME);
    }

    public static class TransportDeleteInternalRepositoryAction
    extends TransportAction<DeleteInternalCcrRepositoryRequest, ActionResponse.Empty> {
        private final RepositoriesService repositoriesService;

        @Inject
        public TransportDeleteInternalRepositoryAction(RepositoriesService repositoriesService, ActionFilters actionFilters, TransportService transportService) {
            super(DeleteInternalCcrRepositoryAction.NAME, actionFilters, transportService.getTaskManager(), (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
            this.repositoriesService = repositoriesService;
        }

        protected void doExecute(Task task, DeleteInternalCcrRepositoryRequest request, ActionListener<ActionResponse.Empty> listener) {
            ProjectId projectId = ProjectId.DEFAULT;
            this.repositoriesService.unregisterInternalRepository(projectId, request.getName());
            listener.onResponse((Object)ActionResponse.Empty.INSTANCE);
        }
    }
}

