/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.aggregations.metric;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.aggregations.metric.ArrayValuesSource;
import org.elasticsearch.aggregations.metric.InternalMatrixStats;
import org.elasticsearch.aggregations.metric.RunningStats;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

final class MatrixStatsAggregator
extends MetricsAggregator {
    private final ArrayValuesSource.NumericArrayValuesSource valuesSources;
    ObjectArray<RunningStats> stats;

    MatrixStatsAggregator(String name, Map<String, ValuesSource.Numeric> valuesSources, AggregationContext context, Aggregator parent, MultiValueMode multiValueMode, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        if (valuesSources != null && !valuesSources.isEmpty()) {
            this.valuesSources = new ArrayValuesSource.NumericArrayValuesSource(valuesSources, multiValueMode);
            this.stats = context.bigArrays().newObjectArray(1L);
        } else {
            this.valuesSources = null;
        }
    }

    public ScoreMode scoreMode() {
        return this.valuesSources != null && this.valuesSources.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSources == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final NumericDoubleValues[] values = new NumericDoubleValues[this.valuesSources.fieldNames().length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.valuesSources.getField(i, aggCtx.getLeafReaderContext());
        }
        return new LeafBucketCollectorBase(sub, values){
            final String[] fieldNames;
            final double[] fieldVals;
            {
                super(arg0, arg1);
                this.fieldNames = MatrixStatsAggregator.this.valuesSources.fieldNames();
                this.fieldVals = new double[this.fieldNames.length];
            }

            public void collect(int doc, long bucket) throws IOException {
                if (this.includeDocument(doc)) {
                    MatrixStatsAggregator.this.stats = MatrixStatsAggregator.this.bigArrays().grow(MatrixStatsAggregator.this.stats, bucket + 1L);
                    RunningStats stat = (RunningStats)MatrixStatsAggregator.this.stats.get(bucket);
                    if (stat == null) {
                        stat = new RunningStats(this.fieldNames, this.fieldVals);
                        MatrixStatsAggregator.this.stats.set(bucket, (Object)stat);
                    } else {
                        stat.add(this.fieldNames, this.fieldVals);
                    }
                }
            }

            private boolean includeDocument(int doc) throws IOException {
                for (int i = 0; i < this.fieldVals.length; ++i) {
                    double value;
                    NumericDoubleValues doubleValues = values[i];
                    if (doubleValues.advanceExact(doc)) {
                        value = doubleValues.doubleValue();
                        if (value == Double.NEGATIVE_INFINITY) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    this.fieldVals[i] = value;
                }
                return true;
            }
        };
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSources == null || bucket >= this.stats.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalMatrixStats(this.name, this.stats.size(), (RunningStats)this.stats.get(bucket), null, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalMatrixStats(this.name, 0L, null, null, this.metadata());
    }

    public void doClose() {
        Releasables.close(this.stats);
    }
}

