/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.role;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.action.role.DeleteRoleRequestBuilder;
import org.elasticsearch.xpack.core.security.action.role.DeleteRoleResponse;
import org.elasticsearch.xpack.security.rest.action.role.NativeRoleBaseRestHandler;

@ServerlessScope(value=Scope.PUBLIC)
public class RestDeleteRoleAction
extends NativeRoleBaseRestHandler {
    public RestDeleteRoleAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, "/_security/role/{name}"));
    }

    public String getName() {
        return "security_delete_role_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String name = request.param("name");
        String refresh = request.param("refresh");
        return channel -> new DeleteRoleRequestBuilder((ElasticsearchClient)client).name(name).setRefreshPolicy(refresh).execute((ActionListener)new RestBuilderListener<DeleteRoleResponse>(this, channel){

            public RestResponse buildResponse(DeleteRoleResponse response, XContentBuilder builder) throws Exception {
                return new RestResponse(response.found() ? RestStatus.OK : RestStatus.NOT_FOUND, builder.startObject().field("found", response.found()).endObject());
            }
        });
    }
}

