/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.metric;

import java.util.Objects;
import java.util.function.LongSupplier;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.metric.LongHistogram;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.xpack.security.metric.SecurityMetricAttributesBuilder;
import org.elasticsearch.xpack.security.metric.SecurityMetricType;

public final class SecurityMetrics<C> {
    private final LongCounter successCounter;
    private final LongCounter failuresCounter;
    private final LongHistogram timeHistogram;
    private final SecurityMetricAttributesBuilder<C> attributesBuilder;
    private final LongSupplier nanoTimeSupplier;
    private final SecurityMetricType metricType;

    public SecurityMetrics(SecurityMetricType metricType, MeterRegistry meterRegistry, SecurityMetricAttributesBuilder<C> attributesBuilder, LongSupplier nanoTimeSupplier) {
        this.metricType = Objects.requireNonNull(metricType);
        this.successCounter = metricType.successMetricInfo().registerAsLongCounter(meterRegistry);
        this.failuresCounter = metricType.failuresMetricInfo().registerAsLongCounter(meterRegistry);
        this.timeHistogram = metricType.timeMetricInfo().registerAsLongHistogram(meterRegistry);
        this.attributesBuilder = Objects.requireNonNull(attributesBuilder);
        this.nanoTimeSupplier = Objects.requireNonNull(nanoTimeSupplier);
    }

    public SecurityMetricType type() {
        return this.metricType;
    }

    public long relativeTimeInNanos() {
        return this.nanoTimeSupplier.getAsLong();
    }

    public void recordSuccess(C context) {
        this.successCounter.incrementBy(1L, this.attributesBuilder.build(context));
    }

    public void recordFailure(C context, String failureReason) {
        this.failuresCounter.incrementBy(1L, this.attributesBuilder.build(context, failureReason));
    }

    public void recordTime(C context, long startTimeNano) {
        long timeInNanos = this.relativeTimeInNanos() - startTimeNano;
        this.timeHistogram.record(timeInNanos, this.attributesBuilder.build(context));
    }
}

