/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DelegatingActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.ScrollHelper;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.action.role.BulkRolesResponse;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheAction;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheRequest;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheResponse;
import org.elasticsearch.xpack.core.security.action.role.DeleteRoleRequest;
import org.elasticsearch.xpack.core.security.action.role.QueryRoleResponse;
import org.elasticsearch.xpack.core.security.action.role.RoleDescriptorRequestValidator;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.RemoteClusterPermissions;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivileges;
import org.elasticsearch.xpack.core.security.authz.store.RoleRetrievalResult;
import org.elasticsearch.xpack.core.security.authz.support.DLSRoleQueryValidator;
import org.elasticsearch.xpack.security.authz.ReservedRoleNameChecker;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;
import org.elasticsearch.xpack.security.support.SecurityMigrations;

public class NativeRolesStore
implements BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>> {
    public static final String NATIVE_ROLES_ENABLED = "xpack.security.authc.native_roles.enabled";
    private static final Logger logger = LogManager.getLogger(NativeRolesStore.class);
    private static final RoleDescriptor.Parser ROLE_DESCRIPTOR_PARSER = RoleDescriptor.parserBuilder().allow2xFormat(true).allowDescription(true).build();
    private static final Set<DocWriteResponse.Result> UPDATE_ROLES_REFRESH_CACHE_RESULTS = Set.of(DocWriteResponse.Result.CREATED, DocWriteResponse.Result.UPDATED, DocWriteResponse.Result.DELETED);
    private final Settings settings;
    private final Client client;
    private final XPackLicenseState licenseState;
    private final boolean enabled;
    private final SecurityIndexManager securityIndex;
    private final ClusterService clusterService;
    private final ReservedRoleNameChecker reservedRoleNameChecker;
    private final NamedXContentRegistry xContentRegistry;

    public NativeRolesStore(Settings settings, Client client, XPackLicenseState licenseState, SecurityIndexManager securityIndex, ClusterService clusterService, ReservedRoleNameChecker reservedRoleNameChecker, NamedXContentRegistry xContentRegistry) {
        this.settings = settings;
        this.client = client;
        this.licenseState = licenseState;
        this.securityIndex = securityIndex;
        this.clusterService = clusterService;
        this.reservedRoleNameChecker = reservedRoleNameChecker;
        this.xContentRegistry = xContentRegistry;
        this.enabled = settings.getAsBoolean(NATIVE_ROLES_ENABLED, Boolean.valueOf(true));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void accept(Set<String> names, ActionListener<RoleRetrievalResult> listener) {
        this.getRoleDescriptors(names, listener);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void getRoleDescriptors(Set<String> names, ActionListener<RoleRetrievalResult> listener) {
        SecurityIndexManager.IndexState projectSecurityIndex;
        block10: {
            block9: {
                if (!this.enabled) {
                    listener.onResponse((Object)RoleRetrievalResult.success(Set.of()));
                    return;
                }
                if (!$assertionsDisabled && names != null) {
                    if (!names.stream().noneMatch(this.reservedRoleNameChecker::isReserved)) {
                        throw new AssertionError((Object)"native roles store should not be called with reserved role names");
                    }
                }
                if (!(projectSecurityIndex = this.securityIndex.forCurrentProject()).indexExists()) {
                    listener.onResponse((Object)RoleRetrievalResult.success(Collections.emptySet()));
                    return;
                }
                if (!projectSecurityIndex.isAvailable(SecurityIndexManager.Availability.SEARCH_SHARDS)) {
                    listener.onResponse((Object)RoleRetrievalResult.failure((Exception)((Object)projectSecurityIndex.getUnavailableReason(SecurityIndexManager.Availability.SEARCH_SHARDS))));
                    return;
                }
                if (names == null) break block9;
                if (!names.isEmpty()) break block10;
            }
            projectSecurityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
                BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)RoleDescriptor.Fields.TYPE.getPreferredName(), (String)"role")).mustNot((QueryBuilder)QueryBuilders.termQuery((String)"metadata_flattened._reserved", (boolean)true));
                Supplier supplier = this.client.threadPool().getThreadContext().newRestorableContext(false);
                try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("security");){
                    SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".security"}).setScroll((TimeValue)SearchService.DEFAULT_KEEPALIVE_SETTING.get(this.settings)).setQuery((QueryBuilder)query).setSize(1000).setFetchSource(true).request();
                    request.indicesOptions().ignoreUnavailable();
                    ScrollHelper.fetchAllByEntity((Client)this.client, (SearchRequest)request, (ActionListener)new ContextPreservingActionListener(supplier, ActionListener.wrap(roles -> listener.onResponse((Object)RoleRetrievalResult.success(new HashSet(roles))), e -> listener.onResponse((Object)RoleRetrievalResult.failure((Exception)e)))), hit -> NativeRolesStore.transformRole(hit.getId(), hit.getSourceRef(), logger, this.licenseState));
                }
            });
            return;
        }
        if (names.size() == 1) {
            this.getRoleDescriptor(Objects.requireNonNull(names.iterator().next()), listener);
            return;
        }
        projectSecurityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
            String[] roleIds = (String[])names.stream().map(NativeRolesStore::getIdForRole).toArray(String[]::new);
            MultiGetRequest multiGetRequest = (MultiGetRequest)this.client.prepareMultiGet().addIds(".security", roleIds).request();
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)multiGetRequest, (ActionListener)ActionListener.wrap(mGetResponse -> {
                MultiGetItemResponse[] responses = mGetResponse.getResponses();
                HashSet<RoleDescriptor> descriptors = new HashSet<RoleDescriptor>();
                for (int i = 0; i < responses.length; ++i) {
                    MultiGetItemResponse item = responses[i];
                    if (item.isFailed()) {
                        Exception failure = item.getFailure().getFailure();
                        for (int j = i + 1; j < responses.length; ++j) {
                            item = responses[j];
                            if (!item.isFailed()) continue;
                            failure.addSuppressed(failure);
                        }
                        listener.onResponse((Object)RoleRetrievalResult.failure((Exception)failure));
                        return;
                    }
                    if (!item.getResponse().isExists()) continue;
                    descriptors.add(this.transformRole(item.getResponse()));
                }
                listener.onResponse((Object)RoleRetrievalResult.success(descriptors));
            }, e -> listener.onResponse((Object)RoleRetrievalResult.failure((Exception)e))), (arg_0, arg_1) -> ((Client)this.client).multiGet(arg_0, arg_1));
        });
    }

    public boolean isMetadataSearchable() {
        SecurityIndexManager.IndexState projectSecurityIndex = this.securityIndex.forCurrentProject();
        return projectSecurityIndex.isCreatedOnLatestVersion() || projectSecurityIndex.isMigrationsVersionAtLeast(SecurityMigrations.ROLE_METADATA_FLATTENED_MIGRATION_VERSION);
    }

    public void queryRoleDescriptors(SearchSourceBuilder searchSourceBuilder, ActionListener<QueryRoleResponse.QueryRoleResult> listener) {
        if (!this.enabled) {
            listener.onResponse((Object)QueryRoleResponse.QueryRoleResult.EMPTY);
            return;
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{".security"}, searchSourceBuilder);
        SecurityIndexManager.IndexState projectSecurityIndex = this.securityIndex.forCurrentProject();
        if (!projectSecurityIndex.indexExists()) {
            logger.debug("security index does not exist");
            listener.onResponse((Object)QueryRoleResponse.QueryRoleResult.EMPTY);
        } else if (!projectSecurityIndex.isAvailable(SecurityIndexManager.Availability.SEARCH_SHARDS)) {
            listener.onFailure((Exception)((Object)projectSecurityIndex.getUnavailableReason(SecurityIndexManager.Availability.SEARCH_SHARDS)));
        } else {
            projectSecurityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)TransportSearchAction.TYPE, (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> {
                long total = searchResponse.getHits().getTotalHits().value();
                if (total == 0L) {
                    logger.debug("No roles found for query [{}]", (Object)searchRequest.source().query());
                    listener.onResponse((Object)QueryRoleResponse.QueryRoleResult.EMPTY);
                    return;
                }
                SearchHit[] hits = searchResponse.getHits().getHits();
                List<QueryRoleResponse.Item> items = Arrays.stream(hits).map(hit -> {
                    RoleDescriptor roleDescriptor = NativeRolesStore.transformRole(hit.getId(), hit.getSourceRef(), logger, this.licenseState);
                    if (roleDescriptor == null) {
                        return null;
                    }
                    return new QueryRoleResponse.Item(roleDescriptor, hit.getSortValues());
                }).filter(Objects::nonNull).toList();
                listener.onResponse((Object)new QueryRoleResponse.QueryRoleResult(total, items));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
        }
    }

    public void deleteRole(final DeleteRoleRequest deleteRoleRequest, final ActionListener<Boolean> listener) {
        if (!this.enabled) {
            listener.onFailure((Exception)new IllegalStateException("Native role management is disabled"));
            return;
        }
        SecurityIndexManager.IndexState projectSecurityIndex = this.securityIndex.forCurrentProject();
        if (!projectSecurityIndex.indexExists()) {
            listener.onResponse((Object)false);
        } else if (!projectSecurityIndex.isAvailable(SecurityIndexManager.Availability.PRIMARY_SHARDS)) {
            listener.onFailure((Exception)((Object)projectSecurityIndex.getUnavailableReason(SecurityIndexManager.Availability.PRIMARY_SHARDS)));
        } else {
            projectSecurityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
                DeleteRequest request = this.createRoleDeleteRequest(deleteRoleRequest.name());
                request.setRefreshPolicy(deleteRoleRequest.getRefreshPolicy());
                ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)request, (ActionListener)new ActionListener<DeleteResponse>(){

                    public void onResponse(DeleteResponse deleteResponse) {
                        NativeRolesStore.this.clearRoleCache(deleteRoleRequest.name(), listener, Boolean.valueOf(deleteResponse.getResult() == DocWriteResponse.Result.DELETED));
                    }

                    public void onFailure(Exception e) {
                        logger.error("failed to delete role from the index", (Throwable)e);
                        listener.onFailure(e);
                    }
                }, (arg_0, arg_1) -> ((Client)this.client).delete(arg_0, arg_1));
            });
        }
    }

    public void deleteRoles(List<String> roleNames, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<BulkRolesResponse> listener) {
        this.deleteRoles(roleNames, refreshPolicy, true, listener);
    }

    public void deleteRoles(final Collection<String> roleNames, WriteRequest.RefreshPolicy refreshPolicy, boolean validateRoleNames, final ActionListener<BulkRolesResponse> listener) {
        if (!this.enabled) {
            listener.onFailure((Exception)new IllegalStateException("Native role management is disabled"));
            return;
        }
        BulkRequest bulkRequest = new BulkRequest().setRefreshPolicy(refreshPolicy);
        final HashMap<String, Exception> validationErrorByRoleName = new HashMap<String, Exception>();
        for (String roleName : roleNames) {
            if (validateRoleNames && this.reservedRoleNameChecker.isReserved(roleName)) {
                validationErrorByRoleName.put(roleName, new IllegalArgumentException("role [" + roleName + "] is reserved and cannot be deleted"));
                continue;
            }
            bulkRequest.add(this.createRoleDeleteRequest(roleName));
        }
        if (bulkRequest.numberOfActions() == 0) {
            this.bulkResponseWithOnlyValidationErrors(roleNames, validationErrorByRoleName, listener);
            return;
        }
        SecurityIndexManager.IndexState projectSecurityIndex = this.securityIndex.forCurrentProject();
        if (!projectSecurityIndex.indexExists()) {
            logger.debug("security index does not exist");
            listener.onResponse((Object)new BulkRolesResponse(List.of()));
        } else if (!projectSecurityIndex.isAvailable(SecurityIndexManager.Availability.PRIMARY_SHARDS)) {
            listener.onFailure((Exception)((Object)projectSecurityIndex.getUnavailableReason(SecurityIndexManager.Availability.PRIMARY_SHARDS)));
        } else {
            projectSecurityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)bulkRequest, (ActionListener)new ActionListener<BulkResponse>(){

                public void onResponse(BulkResponse bulkResponse) {
                    NativeRolesStore.this.bulkResponseAndRefreshRolesCache(roleNames, bulkResponse, validationErrorByRoleName, (ActionListener<BulkRolesResponse>)listener);
                }

                public void onFailure(Exception e) {
                    logger.error(() -> "failed to delete roles", (Throwable)e);
                    listener.onFailure(e);
                }
            }, (arg_0, arg_1) -> ((Client)this.client).bulk(arg_0, arg_1)));
        }
    }

    private void bulkResponseAndRefreshRolesCache(Collection<String> roleNames, BulkResponse bulkResponse, Map<String, Exception> validationErrorByRoleName, ActionListener<BulkRolesResponse> listener) {
        Iterator bulkItemResponses = bulkResponse.iterator();
        BulkRolesResponse.Builder bulkPutRolesResponseBuilder = new BulkRolesResponse.Builder();
        ArrayList rolesToRefreshInCache = new ArrayList(roleNames.size());
        roleNames.stream().map(roleName -> {
            if (validationErrorByRoleName.containsKey(roleName)) {
                return BulkRolesResponse.Item.failure((String)roleName, (Exception)((Exception)validationErrorByRoleName.get(roleName)));
            }
            BulkItemResponse resp = (BulkItemResponse)bulkItemResponses.next();
            if (resp.isFailed()) {
                return BulkRolesResponse.Item.failure((String)roleName, (Exception)resp.getFailure().getCause());
            }
            if (UPDATE_ROLES_REFRESH_CACHE_RESULTS.contains(resp.getResponse().getResult())) {
                rolesToRefreshInCache.add(roleName);
            }
            return BulkRolesResponse.Item.success((String)roleName, (DocWriteResponse.Result)resp.getResponse().getResult());
        }).forEach(arg_0 -> ((BulkRolesResponse.Builder)bulkPutRolesResponseBuilder).addItem(arg_0));
        this.clearRoleCache((String[])rolesToRefreshInCache.toArray(String[]::new), ActionListener.wrap(res -> listener.onResponse((Object)bulkPutRolesResponseBuilder.build()), arg_0 -> listener.onFailure(arg_0)), bulkResponse);
    }

    private void bulkResponseWithOnlyValidationErrors(Collection<String> roleNames, Map<String, Exception> validationErrorByRoleName, ActionListener<BulkRolesResponse> listener) {
        BulkRolesResponse.Builder bulkRolesResponseBuilder = new BulkRolesResponse.Builder();
        roleNames.stream().map(roleName -> BulkRolesResponse.Item.failure((String)roleName, (Exception)((Exception)validationErrorByRoleName.get(roleName)))).forEach(arg_0 -> ((BulkRolesResponse.Builder)bulkRolesResponseBuilder).addItem(arg_0));
        listener.onResponse((Object)bulkRolesResponseBuilder.build());
    }

    private void executeAsyncRolesBulkRequest(BulkRequest bulkRequest, ActionListener<BulkResponse> listener) {
        this.securityIndex.forCurrentProject().checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)bulkRequest, (ActionListener)listener, (arg_0, arg_1) -> ((Client)this.client).bulk(arg_0, arg_1)));
    }

    private Exception validateRoleDescriptor(RoleDescriptor role) {
        ActionRequestValidationException validationException = null;
        validationException = RoleDescriptorRequestValidator.validate((RoleDescriptor)role, validationException);
        if (this.reservedRoleNameChecker.isReserved(role.getName())) {
            throw ValidateActions.addValidationError((String)("Role [" + role.getName() + "] is reserved and may not be used."), (ActionRequestValidationException)validationException);
        }
        if (role.isUsingDocumentOrFieldLevelSecurity() && !SecurityField.DOCUMENT_LEVEL_SECURITY_FEATURE.checkWithoutTracking(this.licenseState)) {
            return LicenseUtils.newComplianceException((String)"field and document level security");
        }
        if (role.hasRemoteIndicesPrivileges() && this.clusterService.state().getMinTransportVersion().before((VersionId)RemoteClusterPortSettings.TRANSPORT_VERSION_ADVANCED_REMOTE_CLUSTER_SECURITY)) {
            return new IllegalStateException("all nodes must have version [" + RemoteClusterPortSettings.TRANSPORT_VERSION_ADVANCED_REMOTE_CLUSTER_SECURITY.toReleaseVersion() + "] or higher to support remote indices privileges");
        }
        if (role.hasRemoteClusterPermissions() && this.clusterService.state().getMinTransportVersion().before((VersionId)RemoteClusterPermissions.ROLE_REMOTE_CLUSTER_PRIVS)) {
            return new IllegalStateException("all nodes must have version [" + RemoteClusterPermissions.ROLE_REMOTE_CLUSTER_PRIVS.toReleaseVersion() + "] or higher to support remote cluster privileges");
        }
        if (role.hasDescription() && this.clusterService.state().getMinTransportVersion().before((VersionId)RoleDescriptor.SECURITY_ROLE_DESCRIPTION)) {
            return new IllegalStateException("all nodes must have version [" + RoleDescriptor.SECURITY_ROLE_DESCRIPTION.toReleaseVersion() + "] or higher to support specifying role description");
        }
        if (Arrays.stream(role.getConditionalClusterPrivileges()).anyMatch(privilege -> privilege instanceof ConfigurableClusterPrivileges.ManageRolesPrivilege) && this.clusterService.state().getMinTransportVersion().before((VersionId)TransportVersions.V_8_16_0)) {
            return new IllegalStateException("all nodes must have version [" + TransportVersions.V_8_16_0.toReleaseVersion() + "] or higher to support the manage roles privilege");
        }
        try {
            DLSRoleQueryValidator.validateQueryField((RoleDescriptor.IndicesPrivileges[])role.getIndicesPrivileges(), (NamedXContentRegistry)this.xContentRegistry);
        }
        catch (IllegalArgumentException | ElasticsearchException e) {
            return e;
        }
        return validationException;
    }

    public void putRole(WriteRequest.RefreshPolicy refreshPolicy, final RoleDescriptor role, final ActionListener<Boolean> listener) {
        if (!this.enabled) {
            listener.onFailure((Exception)new IllegalStateException("Native role management is disabled"));
            return;
        }
        Exception validationException = this.validateRoleDescriptor(role);
        if (validationException != null) {
            listener.onFailure(validationException);
            return;
        }
        try {
            final IndexRequest indexRequest = this.createRoleIndexRequest(role);
            indexRequest.setRefreshPolicy(refreshPolicy);
            this.securityIndex.forCurrentProject().prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)indexRequest, (ActionListener)new ActionListener<DocWriteResponse>(){

                public void onResponse(DocWriteResponse indexResponse) {
                    boolean created = indexResponse.getResult() == DocWriteResponse.Result.CREATED;
                    logger.trace("Created role: [{}]", (Object)indexRequest);
                    NativeRolesStore.this.clearRoleCache(role.getName(), listener, Boolean.valueOf(created));
                }

                public void onFailure(Exception e) {
                    logger.error(() -> "failed to put role [" + role.getName() + "]", (Throwable)e);
                    listener.onFailure(e);
                }
            }, (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1)));
        }
        catch (IOException exception) {
            listener.onFailure((Exception)exception);
        }
    }

    public void putRoles(WriteRequest.RefreshPolicy refreshPolicy, Collection<RoleDescriptor> roles, ActionListener<BulkRolesResponse> listener) {
        this.putRoles(refreshPolicy, roles, true, listener);
    }

    public void putRoles(WriteRequest.RefreshPolicy refreshPolicy, Collection<RoleDescriptor> roles, boolean validateRoleDescriptors, final ActionListener<BulkRolesResponse> listener) {
        if (!this.enabled) {
            listener.onFailure((Exception)new IllegalStateException("Native role management is disabled"));
            return;
        }
        BulkRequest bulkRequest = new BulkRequest().setRefreshPolicy(refreshPolicy);
        final HashMap<String, Exception> validationErrorByRoleName = new HashMap<String, Exception>();
        for (RoleDescriptor role : roles) {
            Exception validationException;
            try {
                validationException = validateRoleDescriptors ? this.validateRoleDescriptor(role) : null;
            }
            catch (Exception e) {
                validationException = e;
            }
            if (validationException != null) {
                validationErrorByRoleName.put(role.getName(), validationException);
                continue;
            }
            try {
                bulkRequest.add(this.createRoleUpsertRequest(role));
            }
            catch (IOException ioException) {
                listener.onFailure((Exception)ioException);
            }
        }
        final List<String> roleNames = roles.stream().map(RoleDescriptor::getName).toList();
        if (bulkRequest.numberOfActions() == 0) {
            this.bulkResponseWithOnlyValidationErrors(roleNames, validationErrorByRoleName, listener);
            return;
        }
        this.securityIndex.forCurrentProject().prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)bulkRequest, (ActionListener)new ActionListener<BulkResponse>(){

            public void onResponse(BulkResponse bulkResponse) {
                NativeRolesStore.this.bulkResponseAndRefreshRolesCache(roleNames, bulkResponse, validationErrorByRoleName, (ActionListener<BulkRolesResponse>)listener);
            }

            public void onFailure(Exception e) {
                logger.error(() -> "failed to put roles", (Throwable)e);
                listener.onFailure(e);
            }
        }, (arg_0, arg_1) -> ((Client)this.client).bulk(arg_0, arg_1)));
    }

    private IndexRequest createRoleIndexRequest(RoleDescriptor role) throws IOException {
        return this.client.prepareIndex(".security").setId(NativeRolesStore.getIdForRole(role.getName())).setSource(this.createRoleXContentBuilder(role)).request();
    }

    private UpdateRequest createRoleUpsertRequest(RoleDescriptor role) throws IOException {
        return this.client.prepareUpdate(".security", NativeRolesStore.getIdForRole(role.getName())).setDoc(this.createRoleXContentBuilder(role)).setDocAsUpsert(true).request();
    }

    private DeleteRequest createRoleDeleteRequest(String roleName) {
        return this.client.prepareDelete(".security", NativeRolesStore.getIdForRole(roleName)).request();
    }

    XContentBuilder createRoleXContentBuilder(RoleDescriptor role) throws IOException {
        assert (!role.hasRestriction()) : "restriction is not supported for native roles";
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
        role.innerToXContent(builder, ToXContent.EMPTY_PARAMS, true);
        builder.field(RoleDescriptor.Fields.METADATA_FLATTENED.getPreferredName(), role.getMetadata());
        if (!role.hasConfigurableClusterPrivileges()) {
            builder.startObject(RoleDescriptor.Fields.GLOBAL.getPreferredName()).endObject();
        }
        if (!role.hasRemoteIndicesPrivileges()) {
            builder.field(RoleDescriptor.Fields.REMOTE_INDICES.getPreferredName(), (Object)RoleDescriptor.RemoteIndicesPrivileges.NONE);
        }
        if (!role.hasRemoteClusterPermissions() && this.clusterService.state().getMinTransportVersion().onOrAfter((VersionId)RemoteClusterPermissions.ROLE_REMOTE_CLUSTER_PRIVS)) {
            builder.array(RoleDescriptor.Fields.REMOTE_CLUSTER.getPreferredName(), new Object[]{RemoteClusterPermissions.NONE});
        }
        if (!role.hasDescription() && this.clusterService.state().getMinTransportVersion().onOrAfter((VersionId)RoleDescriptor.SECURITY_ROLE_DESCRIPTION)) {
            builder.field(RoleDescriptor.Fields.DESCRIPTION.getPreferredName(), "");
        }
        builder.endObject();
        return builder;
    }

    public void usageStats(ActionListener<Map<String, Object>> listener) {
        final Map usageStats = Maps.newMapWithExpectedSize((int)3);
        SecurityIndexManager.IndexState projectSecurityIndex = this.securityIndex.forCurrentProject();
        if (!projectSecurityIndex.isAvailable(SecurityIndexManager.Availability.SEARCH_SHARDS)) {
            usageStats.put("size", 0L);
            usageStats.put("fls", false);
            usageStats.put("dls", false);
            listener.onResponse((Object)usageStats);
        } else {
            projectSecurityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)((MultiSearchRequest)this.client.prepareMultiSearch().add(this.client.prepareSearch(new String[]{".security"}).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)RoleDescriptor.Fields.TYPE.getPreferredName(), (String)"role")).mustNot((QueryBuilder)QueryBuilders.termQuery((String)"metadata_flattened._reserved", (boolean)true))).setTrackTotalHits(true).setSize(0)).add(this.client.prepareSearch(new String[]{".security"}).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)RoleDescriptor.Fields.TYPE.getPreferredName(), (String)"role")).mustNot((QueryBuilder)QueryBuilders.termQuery((String)"metadata_flattened._reserved", (boolean)true)).must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.existsQuery((String)"indices.field_security.grant")).should((QueryBuilder)QueryBuilders.existsQuery((String)"indices.field_security.except")).should((QueryBuilder)QueryBuilders.existsQuery((String)"indices.fields")))).setTrackTotalHits(true).setSize(0).setTerminateAfter(1)).add(this.client.prepareSearch(new String[]{".security"}).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)RoleDescriptor.Fields.TYPE.getPreferredName(), (String)"role")).mustNot((QueryBuilder)QueryBuilders.termQuery((String)"metadata_flattened._reserved", (boolean)true)).filter((QueryBuilder)QueryBuilders.existsQuery((String)"indices.query"))).setTrackTotalHits(true).setSize(0).setTerminateAfter(1)).add(this.client.prepareSearch(new String[]{".security"}).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)RoleDescriptor.Fields.TYPE.getPreferredName(), (String)"role")).mustNot((QueryBuilder)QueryBuilders.termQuery((String)"metadata_flattened._reserved", (boolean)true)).filter((QueryBuilder)QueryBuilders.existsQuery((String)"remote_indices"))).setTrackTotalHits(true).setSize(0)).add(this.client.prepareSearch(new String[]{".security"}).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)RoleDescriptor.Fields.TYPE.getPreferredName(), (String)"role")).mustNot((QueryBuilder)QueryBuilders.termQuery((String)"metadata_flattened._reserved", (boolean)true)).filter((QueryBuilder)QueryBuilders.existsQuery((String)"remote_cluster"))).setTrackTotalHits(true).setSize(0)).request()), (ActionListener)new DelegatingActionListener<MultiSearchResponse, Map<String, Object>>(this, listener){

                public void onResponse(MultiSearchResponse items) {
                    MultiSearchResponse.Item[] responses = items.getResponses();
                    if (responses[0].isFailure()) {
                        usageStats.put("size", 0);
                    } else {
                        usageStats.put("size", responses[0].getResponse().getHits().getTotalHits().value());
                    }
                    if (responses[1].isFailure()) {
                        usageStats.put("fls", false);
                    } else {
                        usageStats.put("fls", responses[1].getResponse().getHits().getTotalHits().value() > 0L);
                    }
                    if (responses[2].isFailure()) {
                        usageStats.put("dls", false);
                    } else {
                        usageStats.put("dls", responses[2].getResponse().getHits().getTotalHits().value() > 0L);
                    }
                    if (responses[3].isFailure()) {
                        usageStats.put("remote_indices", 0);
                    } else {
                        usageStats.put("remote_indices", responses[3].getResponse().getHits().getTotalHits().value());
                    }
                    if (responses[4].isFailure()) {
                        usageStats.put("remote_cluster", 0);
                    } else {
                        usageStats.put("remote_cluster", responses[4].getResponse().getHits().getTotalHits().value());
                    }
                    this.delegate.onResponse((Object)usageStats);
                }
            }, (arg_0, arg_1) -> ((Client)this.client).multiSearch(arg_0, arg_1)));
        }
    }

    public String toString() {
        return "native roles store";
    }

    private void getRoleDescriptor(String roleId, final ActionListener<RoleRetrievalResult> resultListener) {
        SecurityIndexManager.IndexState projectSecurityIndex = this.securityIndex.forCurrentProject();
        if (!projectSecurityIndex.indexExists()) {
            resultListener.onResponse((Object)RoleRetrievalResult.success(Collections.emptySet()));
        } else if (!projectSecurityIndex.isAvailable(SecurityIndexManager.Availability.PRIMARY_SHARDS)) {
            resultListener.onResponse((Object)RoleRetrievalResult.failure((Exception)((Object)projectSecurityIndex.getUnavailableReason(SecurityIndexManager.Availability.PRIMARY_SHARDS))));
        } else {
            projectSecurityIndex.checkIndexVersionThenExecute(e -> resultListener.onResponse((Object)RoleRetrievalResult.failure((Exception)e)), () -> this.executeGetRoleRequest(roleId, new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    RoleDescriptor descriptor = NativeRolesStore.this.transformRole(response);
                    resultListener.onResponse((Object)RoleRetrievalResult.success(descriptor == null ? Collections.emptySet() : Collections.singleton(descriptor)));
                }

                public void onFailure(Exception e) {
                    resultListener.onResponse((Object)RoleRetrievalResult.failure((Exception)e));
                }
            }));
        }
    }

    private void executeGetRoleRequest(String role, ActionListener<GetResponse> listener) {
        this.securityIndex.forCurrentProject().checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)((GetRequest)this.client.prepareGet(".security", NativeRolesStore.getIdForRole(role)).request()), (ActionListener)listener, (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1)));
    }

    private <Response> void clearRoleCache(String role, ActionListener<Response> listener, Response response) {
        this.clearRoleCache(new String[]{role}, listener, response);
    }

    private <Response> void clearRoleCache(final String[] roles, final ActionListener<Response> listener, final Response response) {
        ClearRolesCacheRequest request = new ClearRolesCacheRequest().names(roles);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)ClearRolesCacheAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<ClearRolesCacheResponse>(this){

            public void onResponse(ClearRolesCacheResponse nodes) {
                listener.onResponse(response);
            }

            public void onFailure(Exception e) {
                logger.error(() -> "unable to clear cache for roles [" + Arrays.toString(roles) + "]", (Throwable)e);
                ElasticsearchException exception = new ElasticsearchException("clearing the cache for [" + Arrays.toString(roles) + "] failed. please clear the role cache manually", (Throwable)e, new Object[0]);
                listener.onFailure((Exception)((Object)exception));
            }
        });
    }

    @Nullable
    private RoleDescriptor transformRole(GetResponse response) {
        if (!response.isExists()) {
            return null;
        }
        return NativeRolesStore.transformRole(response.getId(), response.getSourceAsBytesRef(), logger, this.licenseState);
    }

    @Nullable
    static RoleDescriptor transformRole(String id, BytesReference sourceBytes, Logger logger, XPackLicenseState licenseState) {
        assert (id.startsWith("role")) : "[" + id + "] does not have role prefix";
        String name = id.substring("role".length() + 1);
        try {
            RoleDescriptor roleDescriptor = ROLE_DESCRIPTOR_PARSER.parse(name, sourceBytes, XContentType.JSON);
            boolean dlsEnabled = Arrays.stream(roleDescriptor.getIndicesPrivileges()).anyMatch(RoleDescriptor.IndicesPrivileges::isUsingDocumentLevelSecurity);
            boolean flsEnabled = Arrays.stream(roleDescriptor.getIndicesPrivileges()).anyMatch(RoleDescriptor.IndicesPrivileges::isUsingFieldLevelSecurity);
            if ((dlsEnabled || flsEnabled) && !SecurityField.DOCUMENT_LEVEL_SECURITY_FEATURE.checkWithoutTracking(licenseState)) {
                ArrayList<String> unlicensedFeatures = new ArrayList<String>(2);
                if (flsEnabled) {
                    unlicensedFeatures.add("fls");
                }
                if (dlsEnabled) {
                    unlicensedFeatures.add("dls");
                }
                Map transientMap = Maps.newMapWithExpectedSize((int)2);
                transientMap.put("unlicensed_features", unlicensedFeatures);
                transientMap.put("enabled", false);
                return new RoleDescriptor(roleDescriptor.getName(), roleDescriptor.getClusterPrivileges(), roleDescriptor.getIndicesPrivileges(), roleDescriptor.getApplicationPrivileges(), roleDescriptor.getConditionalClusterPrivileges(), roleDescriptor.getRunAs(), roleDescriptor.getMetadata(), transientMap, roleDescriptor.getRemoteIndicesPrivileges(), roleDescriptor.getRemoteClusterPermissions(), roleDescriptor.getRestriction(), roleDescriptor.getDescription());
            }
            return roleDescriptor;
        }
        catch (Exception e) {
            logger.error("error in the format of data for role [" + name + "]", (Throwable)e);
            return null;
        }
    }

    private static String getIdForRole(String roleName) {
        return "role-" + roleName;
    }
}

