/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.saml;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.saml.SamlAuthenticateRequest;
import org.elasticsearch.xpack.core.security.action.saml.SamlAuthenticateResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.saml.SamlAuthenticateResponseHandler;
import org.elasticsearch.xpack.security.authc.saml.SamlToken;

public final class TransportSamlAuthenticateAction
extends HandledTransportAction<SamlAuthenticateRequest, SamlAuthenticateResponse> {
    private final ThreadPool threadPool;
    private final AuthenticationService authenticationService;
    private final SamlAuthenticateResponseHandler tokenHandler;
    private final SecurityContext securityContext;
    private final Executor genericExecutor;

    @Inject
    public TransportSamlAuthenticateAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, AuthenticationService authenticationService, SamlAuthenticateResponseHandler tokenHandler, SecurityContext securityContext) {
        super("cluster:admin/xpack/security/saml/authenticate", transportService, actionFilters, SamlAuthenticateRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.threadPool = threadPool;
        this.authenticationService = authenticationService;
        this.tokenHandler = tokenHandler;
        this.securityContext = securityContext;
        this.genericExecutor = threadPool.generic();
    }

    protected void doExecute(Task task, SamlAuthenticateRequest request, ActionListener<SamlAuthenticateResponse> listener) {
        this.genericExecutor.execute((Runnable)ActionRunnable.wrap(listener, l -> this.doExecuteForked(task, request, (ActionListener<SamlAuthenticateResponse>)l)));
    }

    private void doExecuteForked(Task task, SamlAuthenticateRequest request, ActionListener<SamlAuthenticateResponse> listener) {
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"generic"}));
        SamlToken saml = new SamlToken(request.getSaml(), request.getValidRequestIds(), request.getRealm());
        this.logger.trace("Attempting to authenticate SamlToken [{}]", (Object)saml);
        ThreadContext threadContext = this.threadPool.getThreadContext();
        Authentication originatingAuthentication = this.securityContext.getAuthentication();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            this.authenticationService.authenticate("cluster:admin/xpack/security/saml/authenticate", (TransportRequest)request, saml, (ActionListener<Authentication>)ActionListener.wrap(authentication -> {
                AuthenticationResult result = AuthenticationResult.get((ThreadContext)threadContext);
                if (result == null) {
                    listener.onFailure((Exception)new IllegalStateException("Cannot find User AuthenticationResult on thread context"));
                    return;
                }
                assert (authentication != null) : "authentication should never be null at this point";
                assert (!authentication.isRunAs()) : "saml realm authentication cannot have run-as";
                assert (result.isAuthenticated());
                this.tokenHandler.handleTokenResponse((Authentication)authentication, originatingAuthentication, (AuthenticationResult<User>)result, listener);
            }, e -> {
                this.logger.debug(() -> "SamlToken [" + String.valueOf(saml) + "] could not be authenticated", (Throwable)e);
                listener.onFailure(e);
            }));
        }
    }
}

