/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.repositories.RepositoriesMetrics;
import org.elasticsearch.repositories.SnapshotMetrics;
import org.elasticsearch.repositories.azure.AzureBlobStore;
import org.elasticsearch.repositories.azure.AzureStorageService;
import org.elasticsearch.repositories.azure.LocationMode;
import org.elasticsearch.repositories.blobstore.MeteredBlobStoreRepository;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class AzureRepository
extends MeteredBlobStoreRepository {
    private static final Logger logger = LogManager.getLogger(AzureRepository.class);
    public static final String TYPE = "azure";
    private final ByteSizeValue chunkSize;
    private final AzureStorageService storageService;
    private final boolean readonly;
    private final RepositoriesMetrics repositoriesMetrics;

    public AzureRepository(@Nullable ProjectId projectId, RepositoryMetadata metadata, NamedXContentRegistry namedXContentRegistry, AzureStorageService storageService, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings, RepositoriesMetrics repositoriesMetrics, SnapshotMetrics snapshotMetrics) {
        super(projectId, metadata, namedXContentRegistry, clusterService, bigArrays, recoverySettings, AzureRepository.buildBasePath(metadata), AzureRepository.buildLocation(metadata), snapshotMetrics);
        this.chunkSize = (ByteSizeValue)Repository.CHUNK_SIZE_SETTING.get(metadata.settings());
        this.storageService = storageService;
        this.repositoriesMetrics = repositoriesMetrics;
        LocationMode locationMode = (LocationMode)((Object)Repository.LOCATION_MODE_SETTING.get(metadata.settings()));
        this.readonly = Repository.READONLY_SETTING.exists(metadata.settings()) ? ((Boolean)Repository.READONLY_SETTING.get(metadata.settings())).booleanValue() : locationMode.isSecondary();
    }

    private static BlobPath buildBasePath(RepositoryMetadata metadata) {
        String basePath = org.elasticsearch.common.Strings.trimLeadingCharacter((String)((String)Repository.BASE_PATH_SETTING.get(metadata.settings())), (char)'/');
        if (org.elasticsearch.common.Strings.hasLength((String)basePath)) {
            BlobPath path = BlobPath.EMPTY;
            for (String elem : basePath.split("/")) {
                path = path.add(elem);
            }
            return path;
        }
        return BlobPath.EMPTY;
    }

    private static Map<String, String> buildLocation(RepositoryMetadata metadata) {
        return Map.of("base_path", (String)Repository.BASE_PATH_SETTING.get(metadata.settings()), "container", (String)Repository.CONTAINER_SETTING.get(metadata.settings()));
    }

    protected BlobStore getBlobStore() {
        return super.getBlobStore();
    }

    protected AzureBlobStore createBlobStore() {
        AzureBlobStore blobStore = new AzureBlobStore(this.getProjectId(), this.metadata, this.storageService, this.bigArrays, this.repositoriesMetrics);
        logger.debug(() -> Strings.format((String)"using container [%s], chunk_size [%s], compress [%s], base_path [%s]", (Object[])new Object[]{blobStore, this.chunkSize, this.isCompress(), this.basePath()}));
        return blobStore;
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    protected Set<String> getExtraUsageFeatures() {
        return this.storageService.getExtraUsageFeatures(this.getProjectId(), (String)Repository.CLIENT_NAME.get(this.getMetadata().settings()));
    }

    public static final class Repository {
        @Deprecated
        public static final Setting<String> ACCOUNT_SETTING = Setting.simpleString((String)"account", (String)"default", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.DeprecatedWarning});
        public static final Setting<String> CLIENT_NAME = new Setting("client", ACCOUNT_SETTING, Function.identity(), new Setting.Property[0]);
        public static final Setting<String> CONTAINER_SETTING = Setting.simpleString((String)"container", (String)"elasticsearch-snapshots", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> BASE_PATH_SETTING = Setting.simpleString((String)"base_path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<LocationMode> LOCATION_MODE_SETTING = new Setting("location_mode", LocationMode.PRIMARY_ONLY.toString(), s -> LocationMode.valueOf(s.toUpperCase(Locale.ROOT)), new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)AzureStorageService.MAX_CHUNK_SIZE, (ByteSizeValue)AzureStorageService.MIN_CHUNK_SIZE, (ByteSizeValue)AzureStorageService.MAX_CHUNK_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<Boolean> READONLY_SETTING = Setting.boolSetting((String)"readonly", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        private static final ByteSizeValue DEFAULT_MAX_SINGLE_UPLOAD_SIZE = ByteSizeValue.of((long)256L, (ByteSizeUnit)ByteSizeUnit.MB);
        public static final Setting<ByteSizeValue> MAX_SINGLE_PART_UPLOAD_SIZE_SETTING = Setting.byteSizeSetting((String)"max_single_part_upload_size", (ByteSizeValue)DEFAULT_MAX_SINGLE_UPLOAD_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        static final Setting<Integer> DELETION_BATCH_SIZE_SETTING = Setting.intSetting((String)"delete_objects_max_size", (int)256, (int)1, (int)256, (Setting.Property[])new Setting.Property[0]);
        static final Setting<Integer> MAX_CONCURRENT_BATCH_DELETES_SETTING = Setting.intSetting((String)"max_concurrent_batch_deletes", (int)10, (int)1, (int)100, (Setting.Property[])new Setting.Property[0]);
    }
}

