/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc;

import java.util.function.Supplier;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.lucene.bwc.OldLuceneVersions;

final class ArchiveUsageTracker
implements Runnable {
    private final XPackLicenseState licenseState;
    private final Supplier<ClusterState> clusterStateSupplier;

    ArchiveUsageTracker(XPackLicenseState licenseState, Supplier<ClusterState> clusterStateSupplier) {
        this.clusterStateSupplier = clusterStateSupplier;
        this.licenseState = licenseState;
    }

    @Override
    public void run() {
        if (ArchiveUsageTracker.hasArchiveIndices(this.clusterStateSupplier.get())) {
            OldLuceneVersions.ARCHIVE_FEATURE.check(this.licenseState);
        }
    }

    private static boolean hasArchiveIndices(ClusterState state) {
        for (IndexMetadata indexMetadata : state.metadata().getProject()) {
            if (!indexMetadata.getCreationVersion().isLegacyIndexVersion()) continue;
            return true;
        }
        return false;
    }
}

