/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.PainlessScriptEngine;
import org.elasticsearch.painless.action.PainlessContextAction;
import org.elasticsearch.painless.action.PainlessExecuteAction;
import org.elasticsearch.painless.spi.PainlessExtension;
import org.elasticsearch.painless.spi.PainlessTestScript;
import org.elasticsearch.painless.spi.Whitelist;
import org.elasticsearch.painless.spi.WhitelistLoader;
import org.elasticsearch.painless.spi.annotation.WhitelistAnnotationParser;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptModule;

public final class PainlessPlugin
extends Plugin
implements ScriptPlugin,
ExtensiblePlugin,
ActionPlugin {
    private volatile Map<ScriptContext<?>, List<Whitelist>> whitelists;
    private final SetOnce<PainlessScriptEngine> painlessScriptEngine = new SetOnce();

    public static List<Whitelist> baseWhiteList() {
        return List.of(WhitelistLoader.loadFromResourceFiles(PainlessPlugin.class, (Map)WhitelistAnnotationParser.BASE_ANNOTATION_PARSERS, (String[])new String[]{"org.elasticsearch.txt", "org.elasticsearch.net.txt", "org.elasticsearch.script.fields.txt", "java.lang.txt", "java.math.txt", "java.text.txt", "java.time.txt", "java.time.chrono.txt", "java.time.format.txt", "java.time.temporal.txt", "java.time.zone.txt", "java.util.txt", "java.util.function.txt", "java.util.regex.txt", "java.util.stream.txt", "java.nio.txt"}));
    }

    public ScriptEngine getScriptEngine(Settings settings, Collection<ScriptContext<?>> contexts) {
        Map<ScriptContext<?>, List<Whitelist>> wl = this.whitelists;
        this.whitelists = null;
        assert (wl != null);
        HashMap contextsWithWhitelists = new HashMap();
        List baseWhiteList = PainlessPlugin.baseWhiteList();
        for (ScriptContext<?> context : contexts) {
            List<Whitelist> contextWhitelists = wl.get(context);
            List mergedWhitelists = contextWhitelists != null && !contextWhitelists.isEmpty() ? CollectionUtils.concatLists(baseWhiteList, contextWhitelists) : baseWhiteList;
            contextsWithWhitelists.put(context, mergedWhitelists);
        }
        this.painlessScriptEngine.set((Object)new PainlessScriptEngine(settings, contextsWithWhitelists));
        return (ScriptEngine)this.painlessScriptEngine.get();
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        return Collections.singletonList((PainlessScriptEngine)this.painlessScriptEngine.get());
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(CompilerSettings.REGEX_ENABLED, CompilerSettings.REGEX_LIMIT_FACTOR);
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        HashMap whitelistsBuilder = new HashMap();
        for (ScriptContext context : ScriptModule.CORE_CONTEXTS.values()) {
            ArrayList<Whitelist> contextWhitelists = new ArrayList<Whitelist>();
            if (PainlessPlugin.class.getResource("org.elasticsearch.script." + context.name.replace('-', '_') + ".txt") != null) {
                contextWhitelists.add(WhitelistLoader.loadFromResourceFiles(PainlessPlugin.class, (String[])new String[]{"org.elasticsearch.script." + context.name.replace('-', '_') + ".txt"}));
            }
            whitelistsBuilder.put(context, contextWhitelists);
        }
        ArrayList<Whitelist> testWhitelists = new ArrayList<Whitelist>();
        for (ScriptContext context : ScriptModule.CORE_CONTEXTS.values()) {
            if (ScriptModule.RUNTIME_FIELDS_CONTEXTS.contains(context)) continue;
            testWhitelists.addAll((Collection)whitelistsBuilder.get(context));
        }
        testWhitelists.add(WhitelistLoader.loadFromResourceFiles(PainlessPlugin.class, (String[])new String[]{"org.elasticsearch.json.txt"}));
        whitelistsBuilder.put(PainlessTestScript.CONTEXT, testWhitelists);
        loader.loadExtensions(PainlessExtension.class).stream().flatMap(extension -> extension.getContextWhitelists().entrySet().stream()).forEach(entry -> {
            List existing = whitelistsBuilder.computeIfAbsent((ScriptContext)entry.getKey(), c -> new ArrayList());
            existing.addAll((Collection)entry.getValue());
        });
        this.whitelists = whitelistsBuilder;
    }

    public List<ScriptContext<?>> getContexts() {
        return Collections.singletonList(PainlessTestScript.CONTEXT);
    }

    public List<ActionPlugin.ActionHandler> getActions() {
        ArrayList<ActionPlugin.ActionHandler> actions = new ArrayList<ActionPlugin.ActionHandler>();
        actions.add(new ActionPlugin.ActionHandler(PainlessExecuteAction.INSTANCE, PainlessExecuteAction.TransportAction.class));
        actions.add(new ActionPlugin.ActionHandler(PainlessContextAction.INSTANCE, PainlessContextAction.TransportAction.class));
        return actions;
    }

    public List<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>();
        handlers.add((RestHandler)new PainlessExecuteAction.RestAction());
        handlers.add((RestHandler)new PainlessContextAction.RestAction());
        return handlers;
    }
}

